/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import java.util.HashSet;
import java.util.Set;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.CorruptionParticlePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorruptionCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final ResourceLocation ID = MoreSnifferFlowers.loc("corruption");
    public static final int MAX_RESISTANCE = 5;
    public static final int MAX_CORRUPTION = 150;
    private final LazyOptional<CorruptionCapability> optional = LazyOptional.of(() -> this);
    public int count = 0;
    public boolean isSource = false;
    public boolean isNeighbor = false;
    public int resistance = 0;
    public Set<BlockPos> flowers = new HashSet<BlockPos>();

    public static void sendFlowerParticles(LevelChunk chunk) {
        chunk.getCapability(CapabilityList.CORRUPTION).ifPresent(cap -> {
            int count = 0;
            for (BlockPos pos : cap.flowers) {
                ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new CorruptionParticlePacket(pos, true, true));
                if (++count < 5) continue;
                return;
            }
        });
    }

    public static void onCorruptionSource(Level level, BlockPos pos) {
        LevelChunk chunk = level.m_46745_(pos);
        chunk.getCapability(CapabilityList.CORRUPTION).ifPresent(cap -> {
            boolean hasResistance = cap.resistance > 0;
            cap.isSource = !hasResistance;
            cap.isNeighbor = true;
            ++cap.count;
            if (hasResistance) {
                CorruptionCapability.sendFlowerParticles(chunk);
            }
        });
    }

    public static void cure(LevelChunk chunk) {
        chunk.getCapability(CapabilityList.CORRUPTION).ifPresent(cap -> {
            cap.count = 0;
            cap.isSource = false;
            cap.isNeighbor = false;
        });
    }

    public static boolean areDifferentChunks(Level level, BlockPos pos1, BlockPos pos2) {
        return !level.m_46745_(pos1).m_7697_().equals((Object)level.m_46745_(pos2).m_7697_());
    }

    public static CorruptionCapability get(LevelChunk chunk) {
        return (CorruptionCapability)chunk.getCapability(CapabilityList.CORRUPTION).orElseThrow(IllegalStateException::new);
    }

    public static void printDebug(LevelChunk chunk) {
        if (chunk.m_62953_().m_5776_()) {
            return;
        }
        chunk.getCapability(CapabilityList.CORRUPTION).ifPresent(cap -> MoreSnifferFlowers.LOGGER.debug("Count: " + cap.count + " Resistance: " + cap.resistance + " isSource: " + cap.isSource + " isNeighbor: " + cap.isNeighbor + " Flowers size: " + cap.flowers.size()));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityList.CORRUPTION.orEmpty(cap, this.optional.cast());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("count", this.count);
        tag.m_128405_("resistance", this.resistance);
        tag.m_128379_("isSource", this.isSource);
        tag.m_128379_("isNeighbor", this.isNeighbor);
        ListTag listTag = new ListTag();
        for (BlockPos pos : this.flowers) {
            CompoundTag posTag = NbtUtils.m_129224_((BlockPos)pos);
            listTag.add((Object)posTag);
        }
        tag.m_128365_("flowers", (Tag)listTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.count = nbt.m_128451_("count");
        this.resistance = nbt.m_128451_("resistance");
        this.isSource = nbt.m_128471_("isSource");
        this.isNeighbor = nbt.m_128471_("isNeighbor");
        this.flowers.clear();
        ListTag listTag = nbt.m_128437_("flowers", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            this.flowers.add(NbtUtils.m_129239_((CompoundTag)listTag.m_128728_(i)));
        }
    }
}

