/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.gui.slot;

import java.util.function.Supplier;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.client.gui.slot.DummyContainer;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class HardenedMouthSlot
extends Slot {
    private final Player player;
    private final int index;
    private final Supplier<NonNullList<ItemStack>> itemStorage;

    public HardenedMouthSlot(Player player, int index, int x, int y, Supplier<NonNullList<ItemStack>> itemStorage) {
        super((Container)DummyContainer.INSTANCE, index, x, y);
        this.player = player;
        this.index = index;
        this.itemStorage = itemStorage;
    }

    public boolean m_5857_(ItemStack stack) {
        return this.hasHardenedMouthEffect();
    }

    public boolean m_8010_(Player playerIn) {
        return this.hasHardenedMouthEffect();
    }

    public boolean m_280329_() {
        return this.hasHardenedMouthEffect();
    }

    public ItemStack m_7993_() {
        return (ItemStack)this.itemStorage.get().get(this.index);
    }

    public void m_5852_(ItemStack stack) {
        this.itemStorage.get().set(this.index, (Object)stack);
    }

    public void m_6654_() {
        this.player.getCapability(CapabilityList.MOUTH_SLOTS).ifPresent(hardenedMouthCapability -> hardenedMouthCapability.sync(this.player));
    }

    public void handleCapabilitySlotClick(HardenedMouthSlot slot, Player player, ClickType clickType, int dragType) {
        boolean isRightClick;
        ItemStack slotStack = slot.m_7993_();
        InventoryMenu menu = player.f_36095_;
        ItemStack carried = menu.m_142621_();
        boolean bl = isRightClick = dragType == 1;
        if (player.m_9236_().f_46443_) {
            return;
        }
        switch (clickType) {
            case PICKUP: 
            case QUICK_CRAFT: 
            case PICKUP_ALL: {
                if (slotStack.m_41619_()) {
                    if (carried.m_41619_()) break;
                    int toPlace = isRightClick ? 1 : carried.m_41613_();
                    slot.m_5852_(carried.m_41620_(toPlace));
                    break;
                }
                if (carried.m_41619_()) {
                    int toTake = isRightClick ? (int)Math.ceil((double)slotStack.m_41613_() / 2.0) : slotStack.m_41613_();
                    ItemStack taken = slotStack.m_41620_(toTake);
                    menu.m_142503_(taken);
                    break;
                }
                if (HardenedMouthSlot.canStack(carried, slotStack)) {
                    int maxTransfer = Math.min(carried.m_41613_(), slotStack.m_41741_() - slotStack.m_41613_());
                    slotStack.m_41769_(maxTransfer);
                    carried.m_41774_(maxTransfer);
                    slot.m_5852_(slotStack);
                    break;
                }
                slot.m_5852_(carried);
                menu.m_142503_(slotStack);
                break;
            }
            case QUICK_MOVE: {
                if (slotStack.m_41619_()) break;
                if (!HardenedMouthSlot.moveToPlayerInventory((AbstractContainerMenu)menu, slotStack)) {
                    return;
                }
                slot.m_5852_(ItemStack.f_41583_);
                break;
            }
        }
        slot.m_6654_();
    }

    public static boolean canStack(ItemStack a, ItemStack b) {
        return ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }

    public static boolean moveToPlayerInventory(AbstractContainerMenu menu, ItemStack stackToMove) {
        for (int i = 8; i < 36; ++i) {
            int transferable;
            Slot target = menu.m_38853_(i);
            if (!target.m_5857_(stackToMove)) continue;
            ItemStack targetStack = target.m_7993_();
            if (targetStack.m_41619_()) {
                target.m_5852_(stackToMove.m_41777_());
                stackToMove.m_41764_(0);
                return true;
            }
            if (!HardenedMouthSlot.canStack(stackToMove, targetStack) || (transferable = Math.min(stackToMove.m_41613_(), targetStack.m_41741_() - targetStack.m_41613_())) <= 0) continue;
            targetStack.m_41769_(transferable);
            stackToMove.m_41774_(transferable);
            target.m_5852_(targetStack);
            if (!stackToMove.m_41619_()) continue;
            return true;
        }
        return stackToMove.m_41619_();
    }

    public boolean hasHardenedMouthEffect() {
        return this.player.m_21023_((MobEffect)ModEffects.HARDENED_MOUTH.get());
    }
}

