/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.CropressorBlockEntity;
import net.abraxator.moresnifferflowers.blocks.cropressor.CropressorBlockBase;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CropressorBlockEntityRenderer
implements BlockEntityRenderer<CropressorBlockEntity> {
    private static final Material TEXTURE = new Material(TextureAtlas.f_118259_, MoreSnifferFlowers.loc("block/cropressor"));

    public CropressorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(ModModelLayerLocations.CROPRESSOR);
    }

    public void render(CropressorBlockEntity blockEntity, float partialTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = blockEntity.m_58900_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        Direction direction = ((Direction)blockEntity.m_58900_().m_61143_((Property)CropressorBlockBase.f_54117_)).m_122424_();
        int progress = blockEntity.progress;
        if (progress > 0) {
            double scale = 100.0;
            double d = (double)progress / scale;
            Vec3 factor = switch (direction) {
                case Direction.NORTH -> new Vec3(0.5, 0.0, 1.0 - d);
                case Direction.EAST -> new Vec3(d, 0.0, 0.55);
                case Direction.SOUTH -> new Vec3(0.5, 0.0, d);
                default -> new Vec3(1.0 - d, 0.0, 0.55);
            };
            pose.m_85836_();
            pose.m_85837_(factor.f_82479_, 0.35, factor.f_82481_);
            pose.m_85841_(0.4f, 0.4f, 0.4f);
            itemRenderer.m_269128_(blockEntity.result, ItemDisplayContext.FIXED, light, overlay, pose, buffer, blockEntity.m_58904_(), (int)blockEntity.m_58899_().m_121878_());
            pose.m_85849_();
        }
        pose.m_85836_();
        switch (direction) {
            case NORTH: {
                pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                pose.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                pose.m_85837_(1.5, -2.001, -0.5);
                break;
            }
            case EAST: {
                pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                pose.m_85837_(0.5, -2.001, -0.5);
                break;
            }
            case SOUTH: {
                pose.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                pose.m_85837_(0.5, -1.001, -0.5);
                break;
            }
            case WEST: {
                pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                pose.m_85837_(1.5, -1.001, -0.5);
            }
        }
        float[] rgb = ModColorHandler.hexToRGBLarge(blockEntity.getColor());
        this.renderFace(pose.m_85850_().m_252922_(), pose.m_85850_().m_252943_(), buffer.m_6299_(RenderType.m_110457_()), rgb[0] / 255.0f, rgb[1] / 255.0f, rgb[2] / 255.0f, light, blockEntity.barLength);
        pose.m_85849_();
    }

    private void renderFace(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, float red, float green, float blue, int light, int barLength) {
        float y = 1.0f;
        float size = 1.0f;
        float halfSize = size / 2.0f;
        float x0 = -halfSize;
        float x1 = halfSize;
        float z0 = -halfSize;
        float z1 = halfSize;
        String name = "cropressor_bar" + barLength;
        ResourceLocation resourceLocation = MoreSnifferFlowers.loc("block/" + name);
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(resourceLocation);
        consumer.m_252986_(pose, x1, y, z0).m_85950_(red, green, blue, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, x1, y, z1).m_85950_(red, green, blue, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, x0, y, z1).m_85950_(red, green, blue, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, x0, y, z0).m_85950_(red, green, blue, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

