/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.GiantCropBlockEntity;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.pipeline.VertexConsumerWrapper;
import net.nikdo53.tinymultiblocklib.client.IMultiblockRenderHelper;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class GiantCropBlockEntityRenderer<T extends GiantCropBlockEntity>
implements BlockEntityRenderer<T>,
IMultiblockRenderHelper {
    private final Map<Block, ModelPart> modelPartMap = new HashMap<Block, ModelPart>();

    public GiantCropBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart carrot = context.m_173582_(ModModelLayerLocations.GIANT_CARROT).m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_CARROT.get(), carrot);
        ModelPart potato = context.m_173582_(ModModelLayerLocations.GIANT_POTATO).m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_POTATO.get(), potato);
        ModelPart netherwart = context.m_173582_(ModModelLayerLocations.GIANT_NETHERWART).m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_NETHERWART.get(), netherwart);
        ModelPart beetroot = context.m_173582_(ModModelLayerLocations.GIANT_BEETROOT).m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_BEETROOT.get(), beetroot);
        ModelPart wheat = context.m_173582_(ModModelLayerLocations.GIANT_WHEAT).m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_WHEAT.get(), wheat);
        ModelPart onion = context.m_173582_(ModModelLayerLocations.GIANT_ONION).m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_ONION.get(), onion);
        ModelPart tomato = context.m_173582_(ModModelLayerLocations.GIANT_TOMATO).m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_TOMATO.get(), tomato);
        ModelPart cabbage = context.m_173582_(ModModelLayerLocations.GIANT_CABBAGE).m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_CABBAGE.get(), cabbage);
        ModelPart rice = context.m_173582_(ModModelLayerLocations.GIANT_RICE).m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_RICE.get(), rice);
    }

    public void render(GiantCropBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.m_58900_();
        String path = blockState.m_60734_().m_7705_().replace("block.moresnifferflowers.", "");
        Material TEXTURE = new Material(TextureAtlas.f_118259_, MoreSnifferFlowers.loc("block/" + path));
        PreviewMode previewMode = blockEntity.getPreviewMode();
        Function renderType = this.getRenderTypeFunction(previewMode);
        Object vertexConsumer = TEXTURE.m_119194_(buffer, renderType);
        double growProgress = previewMode.equals((Object)PreviewMode.PLACED) ? blockEntity.growProgress : 1.0;
        float coolPartialTick = growProgress < 1.0 && blockState.m_204336_(ModTags.ModBlockTags.GIANT_CROPS) && (Boolean)blockState.m_61143_((Property)ModStateProperties.CENTER) != false ? partialTick : 0.0f;
        float coolGrowProgress = (float)this.level().m_46467_() - blockEntity.staticGameTime;
        if (growProgress > 0.0 && blockState.m_204336_(ModTags.ModBlockTags.GIANT_CROPS) && ((Boolean)blockState.m_61143_((Property)ModStateProperties.CENTER)).booleanValue()) {
            float yCord = 0.5f;
            float yScale = 1.0f;
            if (!previewMode.equals((Object)PreviewMode.PLACED)) {
                yCord += 1.0f;
            }
            if (growProgress < 1.0) {
                yCord = (coolGrowProgress + coolPartialTick) / 4.0f - 2.0f;
                yScale = Mth.m_14179_((float)((coolGrowProgress + coolPartialTick) / 10.0f), (float)0.0f, (float)1.0f);
            }
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, (double)yCord, 0.5);
            poseStack.m_85841_(1.0f, yScale, 1.0f);
            poseStack.m_252781_(new Quaternionf().rotateX((float)Math.PI));
            if (blockState.m_204336_(ModTags.ModBlockTags.NO_SHADING)) {
                vertexConsumer = new VertexConsumerWrapper((VertexConsumer)vertexConsumer){

                    @NotNull
                    public VertexConsumer m_5601_(float x, float y, float z) {
                        return super.m_5601_(1.0f, 1.0f, 1.0f);
                    }
                };
            }
            this.render(this.modelPartMap.get(blockState.m_60734_()), poseStack, (VertexConsumer)vertexConsumer, packedLight, packedOverlay, blockEntity.getPreviewMode());
            poseStack.m_85849_();
        }
    }

    public int m_142163_() {
        return 256;
    }
}

