/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.init.config.ModClientConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.lighting.QuadLighter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BlockPatternRenderer {
    public static final CameraTracker CAMERA_TRACKER = new CameraTracker();
    public static final BlockPatternRenderer BUFFER_MANAGER = new BlockPatternRenderer();
    private VertexBuffer vertexBuffer;
    private boolean dirty = true;
    private final List<RenderQuad> cachedQuads = new ArrayList<RenderQuad>();

    public static void cacheAndRender(Frustum frustum, Camera camera, Level level, Minecraft minecraft, PoseStack poseStack) {
        double camX = camera.m_90583_().f_82479_;
        double camY = camera.m_90583_().f_82480_;
        double camZ = camera.m_90583_().f_82481_;
        if (level == null || minecraft.f_91074_ == null) {
            return;
        }
        if (CAMERA_TRACKER.hasMoved(camera)) {
            BUFFER_MANAGER.markDirty();
        }
        int chunkRenderDistance = Math.min(ModClientConfig.getBlockPatternRenderDistance(), minecraft.f_91066_.m_193772_());
        poseStack.m_85836_();
        poseStack.m_85837_(-camX, -camY, -camZ);
        ArrayList<LevelChunk> levelChunks = new ArrayList<LevelChunk>();
        ChunkPos playerChunkPos = minecraft.f_91074_.m_146902_();
        for (int x = -chunkRenderDistance; x < chunkRenderDistance; ++x) {
            for (int z = -chunkRenderDistance; z < chunkRenderDistance; ++z) {
                levelChunks.add(level.m_6325_(x + playerChunkPos.f_45578_, z + playerChunkPos.f_45579_));
            }
        }
        BUFFER_MANAGER.cachePatterns(level, camX, camY, camZ, levelChunks, frustum);
        BUFFER_MANAGER.render(poseStack, Minecraft.m_91087_().m_91269_().m_110104_());
        poseStack.m_85849_();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void cachePatterns(Level level, double camX, double camY, double camZ, List<LevelChunk> levelChunks, Frustum frustum) {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        this.cachedQuads.clear();
        frustum.m_113002_(camX, camY, camZ);
        for (LevelChunk chunk : levelChunks) {
            chunk.getCapability(CapabilityList.BLOCK_PATTERNS).ifPresent(storage -> {
                Stream patternPositions = storage.patterns.keySet().stream();
                patternPositions.forEach(pos -> {
                    BlockPatternCapability.PatternData data = storage.getPattern((BlockPos)pos);
                    if (data == null || !frustum.m_113029_(new AABB(pos))) {
                        return;
                    }
                    ResourceLocation resourceLocation = MoreSnifferFlowers.loc("block/block_pattern/" + BlockPattern.fromId(data.patternId()).m_7912_());
                    TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(resourceLocation);
                    BlockState state = level.m_8055_(pos);
                    for (Direction dir : Direction.values()) {
                        int[] lightmap;
                        boolean canRenderFace;
                        BlockPos relativePos = pos.m_121945_(dir);
                        BlockState relativeState = level.m_8055_(relativePos);
                        boolean faceSturdy = state.m_60783_((BlockGetter)level, pos, dir);
                        boolean notBlocked = !relativeState.m_60783_((BlockGetter)level, relativePos, dir.m_122424_());
                        boolean noOcclusion = !relativeState.m_60815_();
                        boolean bl = canRenderFace = faceSturdy && (notBlocked || noOcclusion);
                        if (!canRenderFace) continue;
                        float[] brightness = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
                        boolean smoothLighting = (Boolean)ModClientConfig.BLOCK_PATTERN_SMOOTH_LIGHTING.get();
                        if (smoothLighting) {
                            ModelBlockRenderer.AmbientOcclusionFace aoFace = new ModelBlockRenderer.AmbientOcclusionFace();
                            aoFace.m_111167_((BlockAndTintGetter)level, state, relativePos, dir, new float[Direction.values().length * 2], new BitSet(3), true);
                            brightness = aoFace.f_111149_;
                            lightmap = aoFace.f_111150_;
                        } else {
                            int packed = BlockPatternRenderer.getPackedLight(level, relativePos);
                            if (data.isGlowing()) {
                                packed = 0xF000F0;
                            }
                            lightmap = new int[]{packed, packed, packed, packed};
                        }
                        this.cachedQuads.add(RenderQuad.create(pos, dir, data.color(), sprite, smoothLighting, data.direction(), data.isGlowing(), brightness, lightmap));
                    }
                });
            });
        }
    }

    public void render(PoseStack stack, MultiBufferSource.BufferSource bufferSource) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110457_());
        if (((Boolean)ModClientConfig.BLOCK_PATTERN_TRANSPARENCY.get()).booleanValue()) {
            buffer = bufferSource.m_6299_(RenderType.m_110466_());
        }
        for (RenderQuad quad : this.cachedQuads) {
            quad.render(stack, buffer);
        }
        bufferSource.m_173043_();
    }

    private static void translateToFace(PoseStack stack, Direction face, BlockPos pos) {
        double configOffset = 0.001f;
        float distance = (float)(configOffset * (double)(Math.abs((pos.m_123341_() + pos.m_123342_() + pos.m_123343_()) % 4) + 1));
        float scale = distance * 2.0f;
        switch (face) {
            case UP: {
                stack.m_252880_(1.0f, 1.0f + distance, 0.0f);
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                stack.m_85841_(1.0f + scale, 1.0f, 1.0f + scale);
                stack.m_252880_(-distance, 0.0f, -distance);
                break;
            }
            case DOWN: {
                stack.m_252880_(1.0f, 0.0f - distance, 1.0f);
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_85841_(1.0f + scale, 1.0f, 1.0f + scale);
                stack.m_252880_(-distance, 0.0f, -distance);
                break;
            }
            case NORTH: {
                stack.m_252880_(0.0f, 1.0f, 0.0f - distance);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_85841_(1.0f + scale, 1.0f, 1.0f + scale);
                stack.m_252880_(-distance, 0.0f, -distance);
                break;
            }
            case SOUTH: {
                stack.m_252880_(1.0f, 1.0f, 1.0f + distance);
                stack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_85841_(1.0f + scale, 1.0f, 1.0f + scale);
                stack.m_252880_(-distance, 0.0f, -distance);
                break;
            }
            case WEST: {
                stack.m_252880_(0.0f - distance, 1.0f, 1.0f);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                stack.m_85841_(1.0f + scale, 1.0f, 1.0f + scale);
                stack.m_252880_(-distance, 0.0f, -distance);
                break;
            }
            case EAST: {
                stack.m_252880_(1.0f + distance, 1.0f, 0.0f);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                stack.m_85841_(1.0f + scale, 1.0f, 1.0f + scale);
                stack.m_252880_(-distance, 0.0f, -distance);
            }
        }
    }

    public static int getPackedLight(Level level, BlockPos pos) {
        int blockLight = level.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)blockLight, (int)skyLight);
    }

    public static class CameraTracker {
        private Vec3 lastPosition = Vec3.f_82478_;
        private float lastYaw = 0.0f;
        private float lastPitch = 0.0f;
        private static final double MOVE_THRESHOLD = (double)0.01f;
        private static final float ROTATE_THRESHOLD = 0.2f;

        public boolean hasMoved(Camera camera) {
            Vec3 currentPos = camera.m_90583_();
            float yaw = camera.m_90590_();
            float pitch = camera.m_90589_();
            double dx = currentPos.f_82479_ - this.lastPosition.f_82479_;
            double dy = currentPos.f_82480_ - this.lastPosition.f_82480_;
            double dz = currentPos.f_82481_ - this.lastPosition.f_82481_;
            double distSq = dx * dx + dy * dy + dz * dz;
            float deltaYaw = Math.abs(yaw - this.lastYaw);
            float deltaPitch = Math.abs(pitch - this.lastPitch);
            this.update(camera);
            return distSq > 9.999999552965169E-5 || deltaYaw > 0.2f || deltaPitch > 0.2f;
        }

        public void update(Camera camera) {
            this.lastPosition = camera.m_90583_();
            this.lastYaw = camera.m_90590_();
            this.lastPitch = camera.m_90589_();
        }
    }

    public record RenderQuad(BlockPos pos, Direction direction, int color, TextureAtlasSprite sprite, boolean smoothLighting, Direction rotation, boolean isGlowing, float[] brightness, int[] lightmap) {
        public static RenderQuad create(BlockPos pos, Direction face, int color, TextureAtlasSprite sprite, boolean smoothLighting, Direction rotation, boolean isGlowing, float[] brightness, int[] lightmap) {
            return new RenderQuad(pos.m_7949_(), face, color, sprite, smoothLighting, rotation, isGlowing, brightness, lightmap);
        }

        private void render(PoseStack poseStack, VertexConsumer buffer) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)this.pos.m_123341_(), (float)this.pos.m_123342_(), (float)this.pos.m_123343_());
            BlockPatternRenderer.translateToFace(poseStack, this.direction, this.pos);
            Vec3i n = this.direction.m_122436_();
            float nx = n.m_123341_();
            float ny = n.m_123342_();
            float nz = n.m_123343_();
            int rgb = this.color;
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            if (!this.smoothLighting) {
                float ao = QuadLighter.calculateShade((float)nx, (float)ny, (float)nz, (boolean)false);
                if (!this.isGlowing) {
                    r *= ao;
                    g *= ao;
                    b *= ao;
                }
            }
            Matrix4f pose = poseStack.m_85850_().m_252922_();
            Matrix3f normal = poseStack.m_85850_().m_252943_();
            float u0 = this.sprite.m_118410_();
            float u1 = this.sprite.m_118409_();
            float u2 = this.sprite.m_118409_();
            float u3 = this.sprite.m_118410_();
            float v0 = this.sprite.m_118412_();
            float v1 = this.sprite.m_118412_();
            float v2 = this.sprite.m_118411_();
            float v3 = this.sprite.m_118411_();
            if (this.rotation == Direction.EAST) {
                u0 = this.sprite.m_118409_();
                u1 = this.sprite.m_118409_();
                u2 = this.sprite.m_118410_();
                u3 = this.sprite.m_118410_();
                v0 = this.sprite.m_118411_();
                v1 = this.sprite.m_118412_();
                v2 = this.sprite.m_118412_();
                v3 = this.sprite.m_118411_();
            }
            if (this.rotation == Direction.SOUTH) {
                u0 = this.sprite.m_118409_();
                u1 = this.sprite.m_118410_();
                u2 = this.sprite.m_118410_();
                u3 = this.sprite.m_118409_();
                v0 = this.sprite.m_118411_();
                v1 = this.sprite.m_118411_();
                v2 = this.sprite.m_118412_();
                v3 = this.sprite.m_118412_();
            }
            if (this.rotation == Direction.WEST) {
                u0 = this.sprite.m_118410_();
                u1 = this.sprite.m_118410_();
                u2 = this.sprite.m_118409_();
                u3 = this.sprite.m_118409_();
                v0 = this.sprite.m_118412_();
                v1 = this.sprite.m_118411_();
                v2 = this.sprite.m_118411_();
                v3 = this.sprite.m_118412_();
            }
            float brightness0 = this.brightness[0];
            float brightness1 = this.brightness[1];
            float brightness2 = this.brightness[2];
            float brightness3 = this.brightness[3];
            if (this.isGlowing) {
                brightness0 = 1.0f;
                brightness1 = 1.0f;
                brightness2 = 1.0f;
                brightness3 = 1.0f;
                this.lightmap[0] = 0xF000F0;
                this.lightmap[1] = 0xF000F0;
                this.lightmap[2] = 0xF000F0;
                this.lightmap[3] = 0xF000F0;
            }
            buffer.m_252986_(pose, 1.0f, 0.0f, 0.0f).m_85950_(r * brightness0, g * brightness0, b * brightness0, 1.0f).m_7421_(u1, v2).m_85969_(this.lightmap[0]).m_252939_(normal, nx, ny, nz).m_5752_();
            buffer.m_252986_(pose, 1.0f, 0.0f, 1.0f).m_85950_(r * brightness1, g * brightness1, b * brightness1, 1.0f).m_7421_(u2, v1).m_85969_(this.lightmap[1]).m_252939_(normal, nx, ny, nz).m_5752_();
            buffer.m_252986_(pose, 0.0f, 0.0f, 1.0f).m_85950_(r * brightness2, g * brightness2, b * brightness2, 1.0f).m_7421_(u3, v0).m_85969_(this.lightmap[2]).m_252939_(normal, nx, ny, nz).m_5752_();
            buffer.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_85950_(r * brightness3, g * brightness3, b * brightness3, 1.0f).m_7421_(u0, v3).m_85969_(this.lightmap[3]).m_252939_(normal, nx, ny, nz).m_5752_();
            poseStack.m_85849_();
        }
    }
}

