/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.components.RenderOffsetType;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public abstract class GhostRenderer {
    public static List<GhostRenderer> RENDERERS = new ArrayList<GhostRenderer>();
    protected BlockPos pos;
    protected int ticksRemaining;
    protected final int maxTicksRemaining;
    protected RenderOffsetType renderOffsetType = RenderOffsetType.SCALED;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    protected float alpha = 1.0f;
    protected float maxAlpha = 1.0f;
    protected Integer fadeOutTicks = null;

    protected GhostRenderer(BlockPos pos, int ticksRemaining) {
        this.pos = pos;
        this.ticksRemaining = ticksRemaining;
        this.maxTicksRemaining = ticksRemaining;
    }

    public void addToRenderList() {
        this.maxAlpha = this.alpha;
        RENDERERS.add(this);
    }

    public static void renderAll(float partialTick, Frustum frustum, Camera camera, Level level, PoseStack poseStack) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        double camX = camera.m_90583_().f_82479_;
        double camY = camera.m_90583_().f_82480_;
        double camZ = camera.m_90583_().f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_(-camX, -camY, -camZ);
        ArrayList<GhostRenderer> renderers = new ArrayList<GhostRenderer>(RENDERERS);
        renderers.forEach(renderer -> renderer.prepareAndRender(partialTick, frustum, camera, level, poseStack, buffer));
        poseStack.m_85849_();
    }

    public static void tickAll() {
        RENDERERS.removeIf(renderer -> {
            --renderer.ticksRemaining;
            return renderer.ticksRemaining < 0;
        });
    }

    public void prepareAndRender(float partialTick, Frustum frustum, Camera camera, Level level, PoseStack poseStack, MultiBufferSource.BufferSource buffer) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.pos.m_123341_(), (float)this.pos.m_123342_(), (float)this.pos.m_123343_());
        this.renderOffsetType.applyTransforms(poseStack);
        if (this.fadeOutTicks != null) {
            this.doFadeOut(partialTick);
        }
        this.render(partialTick, frustum, camera, level, poseStack, buffer);
        buffer.m_173043_();
        poseStack.m_85849_();
    }

    private void doFadeOut(float partialTick) {
        if (this.ticksRemaining <= this.fadeOutTicks) {
            float smoothTicks = ((float)this.ticksRemaining - partialTick) / (float)this.fadeOutTicks.intValue();
            if (smoothTicks < 0.0f) {
                smoothTicks = 0.0f;
            }
            this.setARGB(this.red, this.green, this.blue, smoothTicks * this.maxAlpha);
        }
    }

    public abstract void render(float var1, Frustum var2, Camera var3, Level var4, PoseStack var5, MultiBufferSource.BufferSource var6);

    public GhostRenderer setRenderOffsetType(RenderOffsetType renderOffsetType) {
        this.renderOffsetType = renderOffsetType;
        return this;
    }

    public GhostRenderer setARGB(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    public GhostRenderer enableFadeOut(int fadeOutTicks) {
        if (fadeOutTicks <= this.ticksRemaining) {
            this.fadeOutTicks = fadeOutTicks;
        } else {
            MoreSnifferFlowers.LOGGER.error(this + " fadeOutTicks can't be larger than remaining ticks");
        }
        return this;
    }
}

