/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.client.model.entity.SaltBubbleModel;
import net.abraxator.moresnifferflowers.client.renderer.entity.CoolProjectileRenderer;
import net.abraxator.moresnifferflowers.entities.SaltBubbleProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SaltBubbleRenderer
extends EntityRenderer<SaltBubbleProjectile> {
    private final SaltBubbleModel model;
    public static final ResourceLocation TEXTURE_SALT = MoreSnifferFlowers.loc("textures/entity/salt_bubble.png");
    public static final ResourceLocation TEXTURE_SOUR = MoreSnifferFlowers.loc("textures/entity/sour_bubble.png");

    public SaltBubbleRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SaltBubbleModel(context.m_174023_(ModModelLayerLocations.SALT_BUBBLE));
    }

    public void render(SaltBubbleProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (CoolProjectileRenderer.projectileCameraCheck((Entity)entity, this.f_114476_)) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_())));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_())));
            poseStack.m_85837_(0.0, -1.0, 0.0);
            float scale = 1.0f;
            float randomOffset = (float)(entity.m_20182_().f_82479_ + entity.m_20182_().f_82480_ + entity.m_20182_().f_82481_) * 10.0f;
            float time = ((float)entity.f_19797_ + randomOffset + partialTick) / 20.0f;
            float scaleAmount = entity.getState() == 1 ? 0.4f : 0.3f;
            scale = 1.1f + scaleAmount * Mth.m_14031_((float)(time / 2.0f * ((float)Math.PI * 2)));
            poseStack.m_85837_(0.0, (double)(-scale) + 1.1, 0.0);
            if (entity.getState() == 1) {
                poseStack.m_252880_(0.0f, 0.2f * Mth.m_14031_((float)(time / 4.0f * ((float)Math.PI * 2))), 0.0f);
            }
            if (entity.getState() == 2) {
                scale *= 2.0f;
            }
            poseStack.m_85841_(scale, scale, scale);
            this.model.m_7695_(poseStack, buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(SaltBubbleProjectile entity) {
        return entity.isCorrupted() ? TEXTURE_SOUR : TEXTURE_SALT;
    }
}

