/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.components;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import oshi.util.tuples.Pair;

public interface Colorable {
    public static final String TAG_HEX = "MSF_Hex";
    public static final String TAG_ID = "MSF_ID";

    default public TagKey<Block> matchTag() {
        return null;
    }

    default public Pair<EnumProperty<DyeColor>, BooleanProperty> getColorAndEmptyProperties() {
        return new Pair(ModStateProperties.COLOR, (Object)ModStateProperties.EMPTY);
    }

    default public boolean canBeColored(BlockState blockState, Dye dye) {
        return !this.getDyeFromBlock(blockState).color().equals((Object)dye.color());
    }

    default public Dye getDyeFromBlock(BlockState blockState) {
        DyeColor dyeColor = DyeColor.WHITE;
        boolean empty = true;
        if (blockState.m_61138_((Property)this.getColorAndEmptyProperties().getA())) {
            dyeColor = (DyeColor)blockState.m_61143_((Property)this.getColorAndEmptyProperties().getA());
        }
        if (blockState.m_61138_((Property)this.getColorAndEmptyProperties().getB())) {
            empty = (Boolean)blockState.m_61143_((Property)this.getColorAndEmptyProperties().getB());
        }
        return new Dye(dyeColor, !empty ? 1 : 0);
    }

    default public void colorBlock(Level level, BlockPos blockPos, BlockState blockState, Dye dye) {
        level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)this.getColorAndEmptyProperties().getA(), (Comparable)dye.color()));
    }

    default public boolean isColorEmpty(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)this.getColorAndEmptyProperties().getB());
    }

    default public ItemStack add(@Nullable ItemStack dyespria, Dye dyeInside, ItemStack dyeToInsert) {
        if (!(dyeToInsert.m_41720_() instanceof DyeItem)) {
            return dyeToInsert;
        }
        if (dyeInside.isEmpty()) {
            this.onAddDye(dyespria, dyeToInsert, dyeToInsert.m_41613_());
            return ItemStack.f_41583_;
        }
        if (!Dye.dyeCheck(dyeInside, dyeToInsert)) {
            this.onAddDye(dyespria, dyeToInsert, dyeToInsert.m_41613_());
            dyeToInsert.m_41774_(dyeToInsert.m_41613_());
            ItemStack returnStack = Dye.stackFromDye(dyeInside);
            if (DyespriaItem.getDyespriaUses(dyespria) < 4) {
                returnStack.m_41774_(1);
                DyespriaItem.setDyespriaUses(dyespria, 4);
            }
            return returnStack;
        }
        int amountInside = dyeInside.amount();
        int freeSpace = 64 - amountInside;
        if (freeSpace <= 0) {
            return dyeToInsert;
        }
        int amountToAdd = Math.min(dyeToInsert.m_41613_(), freeSpace);
        this.onAddDye(dyespria, dyeToInsert, amountInside + amountToAdd);
        dyeToInsert.m_41774_(amountToAdd);
        return dyeToInsert;
    }

    default public void onAddDye(@Nullable ItemStack destinationStack, ItemStack dye, int amount) {
    }

    default public void particles(RandomSource randomSource, Level level, Dye dye, BlockPos blockPos) {
        this.particles(randomSource, level, dye, blockPos, null);
    }

    default public void particles(RandomSource randomSource, Level level, Dye dye, BlockPos blockPos, @Nullable Direction face) {
        Vector3f vector3f = blockPos.m_252807_().m_252839_();
        if (face != null) {
            vector3f = vector3f.add((Vector3fc)face.m_253071_().div((Vector3fc)new Vector3f(2.0f, 2.0f, 2.0f)));
        }
        for (int i = 0; i <= randomSource.m_216332_(5, 10); ++i) {
            level.m_7106_((ParticleOptions)new DustParticleOptions(dye.isEmpty() ? Vec3.m_82501_((int)0xD5D5D5).m_252839_() : Vec3.m_82501_((int)Dye.colorForDye(this, dye.color())).m_252839_(), 1.0f), (double)vector3f.x + randomSource.m_188500_() - 0.5, (double)vector3f.y + randomSource.m_188500_() - 0.5, (double)vector3f.z + randomSource.m_188500_() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    default public Map<DyeColor, Integer> colorValues() {
        return (Map)Util.m_137469_((Object)Maps.newLinkedHashMap(), map -> Arrays.stream(DyeColor.values()).forEach(color -> map.put(color, color.m_41071_())));
    }

    public static List<DyeColor> vanillaDyeColors() {
        ArrayList<DyeColor> list = new ArrayList<DyeColor>();
        list.add(DyeColor.WHITE);
        list.add(DyeColor.ORANGE);
        list.add(DyeColor.MAGENTA);
        list.add(DyeColor.LIGHT_BLUE);
        list.add(DyeColor.YELLOW);
        list.add(DyeColor.LIME);
        list.add(DyeColor.PINK);
        list.add(DyeColor.GRAY);
        list.add(DyeColor.LIGHT_GRAY);
        list.add(DyeColor.CYAN);
        list.add(DyeColor.PURPLE);
        list.add(DyeColor.BLUE);
        list.add(DyeColor.BROWN);
        list.add(DyeColor.GREEN);
        list.add(DyeColor.RED);
        list.add(DyeColor.BLACK);
        return list;
    }

    public static boolean isModdedDye(DyeColor dyeColor) {
        return !Colorable.vanillaDyeColors().contains(dyeColor);
    }
}

