/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.entities.CorruptedProjectile;
import net.abraxator.moresnifferflowers.entities.goals.BoblingAttackPlayerGoal;
import net.abraxator.moresnifferflowers.entities.goals.BoblingAvoidPlayerGoal;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BoblingEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> DATA_CURED = SynchedEntityData.m_135353_(BoblingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_RUNNING = SynchedEntityData.m_135353_(BoblingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_WANTED_POS = SynchedEntityData.m_135353_(BoblingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> DATA_PLANTING = SynchedEntityData.m_135353_(BoblingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int idleAnimationTimeout = 0;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState plantingAnimationState = new AnimationState();
    private boolean finalizePlanting = false;
    private int plantingProgress = 0;
    private static final int MAX_PLANTING_PROGRESS = 35;

    public BoblingEntity(EntityType<? extends BoblingEntity> entityType, Level level, boolean type) {
        super(entityType, level);
        this.setCured(type);
    }

    public BoblingEntity(EntityType<? extends BoblingEntity> entityType, Level level) {
        this(entityType, level, false);
    }

    public BoblingEntity(Level level, boolean type) {
        this((EntityType<? extends BoblingEntity>)((EntityType)ModEntityTypes.BOBLING.get()), level, type);
    }

    public boolean isCured() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CURED);
    }

    public void setCured(boolean type) {
        this.f_19804_.m_135381_(DATA_CURED, (Object)type);
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RUNNING);
    }

    public void setRunning(boolean running) {
        this.f_19804_.m_135381_(DATA_RUNNING, (Object)running);
    }

    @Nullable
    public BlockPos getWantedPos() {
        return ((Optional)this.f_19804_.m_135370_(DATA_WANTED_POS)).orElse(null);
    }

    public void setWantedPos(Optional<BlockPos> wantedPos) {
        this.f_19804_.m_135381_(DATA_WANTED_POS, wantedPos);
    }

    public boolean isPlanting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLANTING);
    }

    public void setPlanting(boolean plan) {
        this.f_19804_.m_135381_(DATA_PLANTING, (Object)plan);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("cured", this.isCured());
        tag.m_128379_("running", this.isRunning());
        tag.m_128379_("planting", this.isPlanting());
        if (this.getWantedPos() != null) {
            tag.m_128365_("wanted_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.getWantedPos()));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCured(tag.m_128471_("cured"));
        this.setRunning(tag.m_128471_("running"));
        this.setPlanting(tag.m_128471_("planting"));
        this.setWantedPos(Optional.of(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("wanted_pos"))));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CURED, (Object)false);
        this.f_19804_.m_135372_(DATA_RUNNING, (Object)false);
        this.f_19804_.m_135372_(DATA_WANTED_POS, Optional.empty());
        this.f_19804_.m_135372_(DATA_PLANTING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BoblingAttackPlayerGoal(this, 1.5, false));
        this.f_21345_.m_25352_(2, new BoblingAvoidPlayerGoal<Player>(this, Player.class, 16.0f, 1.0, 1.3f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.8f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    protected void m_6475_(DamageSource damageSource, float pDamageAmount) {
        super.m_6475_(damageSource, pDamageAmount);
        if (this.isRunning() && damageSource.m_276093_(DamageTypes.f_268464_) && !this.isCured()) {
            double r = 1.0;
            double checkR = 1.5;
            HashSet<Vec3> set = new HashSet<Vec3>();
            Entity entity = damageSource.m_7639_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ModAdvancementCritters.BOBLING_ATTACK.m_222618_(serverPlayer);
            }
            if (((Boolean)ModServerConfig.CORRUPTED_BOBLING_GRIEFING.get()).booleanValue()) {
                for (double theta = 0.0; theta <= 6.2831854820251465; theta += (double)((float)Math.PI * 2 / (float)this.f_19796_.m_216332_(2, 5))) {
                    this.generateProjectile(set, r, theta + this.m_9236_().f_46441_.m_188500_(), checkR);
                }
            }
        }
        if (!this.isRunning() && damageSource.m_276093_(DamageTypes.f_268464_)) {
            this.setRunning(true);
        }
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        if (this.f_19797_ <= 60) {
            return 0;
        }
        return super.m_5639_(pFallDistance, pDamageMultiplier);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isPlanting()) {
            ++this.plantingProgress;
            if (this.plantingProgress >= 35) {
                this.finalizePlanting = true;
                this.setPlanting(false);
            }
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    public void m_8107_() {
        for (WrappedGoal wrappedGoal : this.f_21345_.m_148105_()) {
            if (wrappedGoal != null) continue;
            MoreSnifferFlowers.LOGGER.error("NULL");
        }
        for (WrappedGoal wrappedGoal : this.f_21346_.m_148105_()) {
            if (wrappedGoal != null) continue;
            MoreSnifferFlowers.LOGGER.error("NULL");
        }
        super.m_8107_();
        if (this.canPlant()) {
            this.plantingProgress = 0;
            this.setPlanting(true);
            this.m_147272_();
            this.m_146922_(this.m_6350_().m_122435_());
        }
        if (this.finalizePlanting && this.m_6084_()) {
            BlockPos blockPos = BlockPos.m_274446_((Position)this.m_20182_()).m_121945_(this.m_6350_());
            if (!this.m_9236_().f_46443_) {
                boolean config = (Boolean)ModServerConfig.CORRUPTED_BOBLING_GRIEFING.get();
                boolean isReplaceable = this.m_9236_().m_8055_(blockPos).m_247087_();
                if (config || isReplaceable) {
                    this.m_9236_().m_46597_(blockPos, ((Block)ModBlocks.CORRUPTED_SAPLING.get()).m_49966_());
                    if (this.m_9236_().m_8055_(blockPos.m_7495_()).m_247087_()) {
                        this.m_9236_().m_46597_(blockPos.m_7495_(), ((Block)ModBlocks.CORRUPTED_GRASS_BLOCK.get()).m_49966_());
                    }
                }
            }
            this.m_146870_();
        }
    }

    private boolean canPlant() {
        BlockPos pos = this.getWantedPos();
        return this.isRunning() && this.m_6084_() && !this.isPlanting() && pos != null && this.m_9236_().m_8055_(pos).m_247087_() && this.m_9236_().m_8055_(pos.m_7495_()).m_60783_((BlockGetter)this.m_9236_(), pos, Direction.UP) && this.m_20182_().m_82509_((Position)pos.m_252807_(), 0.75);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isPlanting()) {
            this.idleAnimationState.m_216973_();
            if (!this.plantingAnimationState.m_216984_()) {
                this.plantingAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            this.plantingAnimationState.m_216973_();
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)ModItems.VIVICUS_ANTIDOTE.get()) && !this.isCured()) {
            this.setCured(true);
            this.particles((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)7118872).m_252839_(), 1.0f));
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    private void particles(ParticleOptions particle) {
        for (int i = 0; i <= 30; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particle, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0);
    }

    private void generateProjectile(Set<Vec3> set, double r, double theta, double checkR) {
        double x = this.m_20185_() + r * (double)Mth.m_14089_((float)((float)theta)) * 0.8;
        double yx = this.m_20186_() + r * (double)Mth.m_14031_((float)((float)theta)) + 0.3;
        double yz = this.m_20186_() + r * (double)Mth.m_14089_((float)((float)theta)) + 0.3;
        double z = this.m_20189_() + r * (double)Mth.m_14031_((float)((float)theta)) * 0.8;
        if (this.f_19796_.m_188501_() > 0.5f) {
            this.createAndAddProjectile(set, checkR, new Vec3(x, this.f_19855_, z));
        }
        if (this.f_19796_.m_188501_() > 0.5f) {
            this.createAndAddProjectile(set, checkR, new Vec3(x, yx, this.f_19856_));
        }
        if (this.f_19796_.m_188501_() > 0.5f) {
            this.createAndAddProjectile(set, checkR, new Vec3(this.f_19854_, yz, z));
        }
    }

    private void createAndAddProjectile(Set<Vec3> set, double checkR, Vec3 vec3) {
        AABB aabb = AABB.m_165882_((Vec3)vec3, (double)checkR, (double)checkR, (double)checkR);
        if (set.stream().noneMatch(arg_0 -> ((AABB)aabb).m_82390_(arg_0))) {
            CorruptedProjectile projectile = new CorruptedProjectile(this.m_9236_());
            projectile.m_146884_(vec3);
            float slowdown = 2.8f;
            Vec3 dir = new Vec3((vec3.m_7096_() - this.m_20185_()) / (double)slowdown, (vec3.m_7098_() - this.m_20186_()) / (double)slowdown, (vec3.m_7094_() - this.m_20189_()) / (double)slowdown);
            projectile.m_20256_(dir);
            this.m_9236_().m_7967_((Entity)projectile);
            set.add(vec3);
        }
    }
}

