/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import net.abraxator.moresnifferflowers.entities.SaltProjectile;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.SaltemoneParticlePacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SaltBubbleProjectile
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Boolean> CORRUPTED = SynchedEntityData.m_135353_(SaltBubbleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(SaltBubbleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vector3f pos;
    private int time;
    private float height;
    private float slowdown;
    private int maxTime;

    public SaltBubbleProjectile(EntityType<? extends SaltBubbleProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SaltBubbleProjectile(double x, double y, double z, Level level) {
        super((EntityType)ModEntityTypes.SALT_BUBBLE.get(), x, y, z, level);
        this.pos = new Vector3f((float)x, (float)y, (float)z);
        this.height = (float)level.f_46441_.m_216332_(10, 20) + level.f_46441_.m_188501_();
        this.slowdown = 1.0f + 0.1f / (this.height * 2.0f);
        this.maxTime = level.f_46441_.m_216332_(4800, 7200);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6097_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean natural = true;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (source.m_7639_() instanceof Player && source.m_269014_()) {
                int orbs = Mth.m_14143_((float)(this.height / 2.0f));
                if (orbs < 3) {
                    orbs = 3;
                }
                int i = serverLevel.f_46441_.m_216332_(2, orbs);
                ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)this.m_20182_(), (int)i);
                serverLevel.m_5594_(null, this.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                natural = false;
            }
        }
        this.pop(natural);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void m_8119_() {
        block4: {
            speed = this.m_20184_();
            state = this.getState();
            if (this.pos == null || state != 0) break block4;
            if (this.pos.distance((Vector3fc)this.m_20182_().m_252839_()) > this.height) ** GOTO lbl-1000
            v0 = new Vec3(0.0, 0.0, 0.0);
            if (speed.m_82554_(v0) < 0.01) lbl-1000:
            // 2 sources

            {
                this.setState(1);
                this.m_20334_(0.0, 0.0, 0.0);
            } else {
                this.m_20334_(speed.f_82479_ / (double)this.slowdown, speed.f_82480_ / (double)this.slowdown, speed.f_82481_ / (double)this.slowdown);
            }
        }
        if (this.pos != null) {
            ++this.time;
            if (this.time >= this.maxTime) {
                this.pop(true);
                return;
            }
        }
        super.m_8119_();
    }

    public void pop(boolean natural) {
        int projectiles = natural ? ((Boolean)ModServerConfig.SALTEMONE_GRIEFING.get() != false && this.f_19796_.m_188501_() < 0.4f ? 1 : 0) : (this.f_19796_.m_188501_() < 0.25f ? 2 : 1);
        this.setState(2);
        for (int i = 0; i < projectiles; ++i) {
            SaltProjectile projectile = new SaltProjectile(this.m_9236_());
            projectile.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            projectile.m_6686_((double)this.f_19796_.m_188501_() - 0.5, (double)this.f_19796_.m_188501_() + 0.5, (double)this.f_19796_.m_188501_() - 0.5, 0.5f, 1.0f);
            projectile.setCorrupted(this.isCorrupted());
            this.m_9236_().m_7967_((Entity)projectile);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11773_, SoundSource.BLOCKS, 10.0f + this.f_19796_.m_188501_() * 3.0f, 0.75f + this.f_19796_.m_188501_() / 2.0f);
            if (this.m_9236_().m_5776_()) continue;
            ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SaltemoneParticlePacket(this.m_20182_().m_252839_()));
        }
        this.m_146870_();
    }

    protected void m_37283_() {
        Vec3 vec3 = new Vec3(0.0, 0.0, 0.0);
        double d0 = vec3.m_165924_();
        this.m_146926_(SaltBubbleProjectile.m_37273_((float)this.f_19860_, (float)((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875))));
        this.m_146922_(SaltBubbleProjectile.m_37273_((float)this.f_19859_, (float)((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875))));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CORRUPTED, (Object)false);
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_146870_();
    }

    protected Item m_7881_() {
        return (Item)ModItems.SALTY_SPICE.get();
    }

    public boolean isCorrupted() {
        return (Boolean)this.f_19804_.m_135370_(CORRUPTED);
    }

    public void setCorrupted(boolean corrupted) {
        this.f_19804_.m_135381_(CORRUPTED, (Object)corrupted);
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("corrupted", this.isCorrupted());
        tag.m_128405_("state", this.getState());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCorrupted(tag.m_128471_("corrupted"));
        this.setState(tag.m_128451_("state"));
    }
}

