/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import java.util.function.Supplier;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.capability.GluedCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record SyncGluedPacket(boolean isGlued, int entityId) {
    public SyncGluedPacket(FriendlyByteBuf buf) {
        this(buf.readBoolean(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isGlued);
        buf.writeInt(this.entityId);
    }

    public static void handle(SyncGluedPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SyncGluedPacket.handlePacket(packet));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SyncGluedPacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(packet.entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            GluedCapability.playSound((Level)level, entity);
            living.getCapability(CapabilityList.GLUED).ifPresent(cap -> {
                cap.isGlued = packet.isGlued;
            });
        }
    }
}

