/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import java.util.function.Supplier;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record SyncMouthSlotsPacket(NonNullList<ItemStack> itemStacks, int cooldown) {
    public static void encode(SyncMouthSlotsPacket msg, FriendlyByteBuf buffer) {
        for (ItemStack itemStack : msg.itemStacks) {
            buffer.m_130055_(itemStack);
        }
        buffer.writeInt(msg.cooldown);
    }

    public static SyncMouthSlotsPacket decode(FriendlyByteBuf buffer) {
        NonNullList itemStacks1 = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{buffer.m_130267_(), buffer.m_130267_()});
        int cooldown = buffer.readInt();
        return new SyncMouthSlotsPacket((NonNullList<ItemStack>)itemStacks1, cooldown);
    }

    public static void handle(SyncMouthSlotsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> SyncMouthSlotsPacket.handlePacket(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(SyncMouthSlotsPacket msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(CapabilityList.MOUTH_SLOTS).ifPresent(cap -> {
                cap.setAllItems(msg.itemStacks);
                cap.setCooldown(msg.cooldown);
            });
        }
    }
}

