/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.nutrition;

import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.effect.MobEffect;

public enum NutritionType {
    SOUR("sour", 15114245, 0.5f),
    SALTY("salty", 9156803, 0.4f),
    SPICY("spicy", 12272432, 0.3f),
    SWEET("sweet", 15104150, 0.2f),
    NEUTRAL("neutral", 9201182, 0.1f);

    public final String name;
    public final int color;
    public final float priority;
    private static final IntFunction<NutritionType> BY_ID;
    public static final Map<NutritionType, Supplier<MobEffect>> NEGATIVE_SOUP_EFFECT_MAP;
    public static final Map<NutritionType, Supplier<MobEffect>> POSITIVE_SOUP_EFFECT_MAP;

    private NutritionType(String name, int color, float priority) {
        this.name = name;
        this.color = color;
        this.priority = priority;
    }

    public static NutritionType byId(int id) {
        return BY_ID.apply(id);
    }

    public static MobEffect getEffect(NutritionType nutritionType, boolean positive) {
        Map<NutritionType, Supplier<MobEffect>> map = positive ? POSITIVE_SOUP_EFFECT_MAP : NEGATIVE_SOUP_EFFECT_MAP;
        return map.get((Object)nutritionType).get();
    }

    static {
        BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])NutritionType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        NEGATIVE_SOUP_EFFECT_MAP = Map.of(SOUR, ModEffects.SLIPPERY, SALTY, ModEffects.SALTY, SPICY, ModEffects.PANTS_ON_FIRE, SWEET, ModEffects.STICKY, NEUTRAL, ModEffects.BLAND);
        POSITIVE_SOUP_EFFECT_MAP = Map.of(SOUR, ModEffects.UNTOUCHABLE, SALTY, ModEffects.COMBO_MEAL, SPICY, ModEffects.HARDENED_MOUTH, SWEET, ModEffects.GLUING_TOUCH, NEUTRAL, ModEffects.WELL_BALANCED);
    }
}

