/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.corrupted;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CorruptedGiantTrunkPlacer
extends TrunkPlacer {
    public static final Codec<CorruptedGiantTrunkPlacer> CODEC = RecordCodecBuilder.create(p_70161_ -> CorruptedGiantTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)p_70161_).apply((Applicative)p_70161_, CorruptedGiantTrunkPlacer::new));

    public CorruptedGiantTrunkPlacer(int pBaseHeight, int pHeightRandA, int pBranchCount) {
        super(pBaseHeight, pHeightRandA, pBranchCount);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.CORRUPTED_GIANT_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int pFreeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> ret = new ArrayList<FoliagePlacer.FoliageAttachment>();
        BlockPos.MutableBlockPos mainTrunk = pos.m_122032_();
        BlockPos.MutableBlockPos tempTrunk = pos.m_122032_();
        int trunkRadius = 2;
        int trunkHeight = 3;
        int treeHeight = random.m_216332_(0, this.f_70264_) + pFreeTreeHeight;
        int branchRnd = random.m_216332_(0, 3);
        for (int d = 0; d < 12; ++d) {
            this.addDirt(mainTrunk.m_7949_(), ret, blockSetter, level, config, random, d);
        }
        for (int i = 0; i < treeHeight; ++i) {
            int u;
            if (i == 0) {
                tempTrunk.m_122190_((Vec3i)mainTrunk);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk, config);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk.m_122173_(Direction.NORTH), config);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk.m_122173_(Direction.EAST), config);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk.m_122173_(Direction.SOUTH), config);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk.m_122173_(Direction.SOUTH), config);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk.m_122173_(Direction.WEST), config);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk.m_122173_(Direction.WEST), config);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk.m_122173_(Direction.NORTH), config);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk.m_122173_(Direction.NORTH), config);
                for (int trunkOrder = 0; trunkOrder < trunkRadius * 2 * 4; ++trunkOrder) {
                    this.fattenTrunk(level, blockSetter, random, pos, config, trunkOrder, ret, trunkHeight, trunkRadius);
                }
                for (u = 0; u < trunkHeight * 2; ++u) {
                    mainTrunk.m_122173_(Direction.UP);
                }
            }
            for (u = 0; u < 4; ++u) {
                int z;
                tempTrunk.m_122190_((Vec3i)mainTrunk);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk, config);
                int n = u == 0 ? 1 : (z = u == 1 ? -1 : 0);
                int x = u == 2 ? 1 : (u == 3 ? -1 : 0);
                tempTrunk.m_122184_(x, 0, z);
                this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk, config);
                if (!(random.m_188501_() < 0.3f) || i >= treeHeight - 4) continue;
                tempTrunk.m_122190_((Vec3i)mainTrunk);
                Direction randDir = Direction.m_235672_((RandomSource)random);
                if (randDir.m_122434_() == Direction.Axis.Y) continue;
                tempTrunk.m_122173_(randDir);
                tempTrunk.m_122173_(randDir.m_122428_());
                for (int p = 0; p < random.m_216332_(2, 4); ++p) {
                    this.m_226187_(level, blockSetter, random, (BlockPos)tempTrunk, config);
                    tempTrunk.m_122173_(Direction.UP);
                }
            }
            if (i % 4 == 2 && i < treeHeight - 5) {
                int branchOrder = branchRnd + Mth.m_14143_((float)((float)i / 4.0f));
                if (random.m_188501_() < 0.3f && branchOrder > 1) {
                    branchOrder -= 2;
                }
                this.addSmallBranch(mainTrunk.m_7949_(), ret, blockSetter, level, config, random, branchOrder);
            }
            if (i == treeHeight - 1) {
                for (int c = 0; c < this.f_70265_; ++c) {
                    this.addTopBranch(mainTrunk.m_7949_(), ret, blockSetter, level, config, random, c);
                }
            }
            mainTrunk.m_122173_(Direction.UP);
        }
        return ret;
    }

    private void fattenTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos1, TreeConfiguration config, int trunkOrder, List<FoliagePlacer.FoliageAttachment> ret, int trunkRadius, int trunkHeight) {
        BlockPos.MutableBlockPos pos = pos1.m_122032_();
        boolean hasDoor = random.m_188501_() < 0.3f && trunkOrder % 4 == 1;
        Vec3i trunkOffset = switch (Mth.m_14143_((float)((float)trunkOrder / 4.0f))) {
            case 0 -> new Vec3i(trunkOrder % 4 - 1, 0, 1);
            case 1 -> new Vec3i(-1, 0, trunkOrder % 4 - 1);
            case 2 -> new Vec3i(-(trunkOrder % 4 - 1), 0, -1);
            case 3 -> new Vec3i(1, 0, -(trunkOrder % 4 - 1));
            default -> new Vec3i(0, 0, 0);
        };
        Direction trunkDir = switch (Mth.m_14143_((float)((float)trunkOrder / 4.0f))) {
            case 0 -> Direction.NORTH;
            case 1 -> Direction.EAST;
            case 2 -> Direction.SOUTH;
            case 3 -> Direction.WEST;
            default -> Direction.NORTH;
        };
        for (int i = 0; i < trunkRadius + 1; ++i) {
            pos.m_122173_(trunkDir);
        }
        pos.m_122193_(trunkOffset);
        if (trunkOrder % 4 == 3) {
            pos.m_122173_(trunkDir.m_122424_());
        }
        int x = 0;
        while (trunkOrder % 4 == 1 ? x <= trunkHeight + 1 : x <= trunkHeight) {
            if (hasDoor && x < 2) {
                pos.m_122173_(Direction.UP);
            } else {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos, config);
                pos.m_122173_(Direction.UP);
            }
            ++x;
        }
        if (trunkOrder % 4 != 3) {
            for (int y = 0; y < 3; ++y) {
                pos.m_122173_(trunkDir.m_122424_());
                this.m_226187_(level, blockSetter, random, (BlockPos)pos, config);
                if (y == 0) {
                    pos.m_122173_(Direction.UP);
                    this.m_226187_(level, blockSetter, random, (BlockPos)pos, config);
                }
                pos.m_122173_(Direction.UP);
            }
        }
    }

    private void addSmallBranch(BlockPos blockPos, List<FoliagePlacer.FoliageAttachment> ret, BiConsumer<BlockPos, BlockState> blockSetter, LevelSimulatedReader level, TreeConfiguration config, RandomSource random, int branchOrder) {
        int v1;
        Direction direction = CorruptedGiantTrunkPlacer.computeBranchDir(random);
        BlockPos.MutableBlockPos pos = blockPos.m_121945_(direction).m_122032_();
        BlockPos.MutableBlockPos defaultPos = blockPos.m_121945_(direction).m_122032_();
        int branchLength = random.m_216332_(7, 9);
        int branchDir = (int)(360.0f / (float)this.f_70265_) * branchOrder;
        int n = branchOrder % 4 == 0 ? 1 : (v1 = branchOrder % 4 == 2 ? -1 : 0);
        int v3 = branchOrder % 4 == 1 ? 1 : (branchOrder % 4 == 3 ? -1 : 0);
        for (int x = 0; x < branchLength; ++x) {
            float branchHeightRand = (float)x / (float)branchLength;
            if (branchHeightRand < random.m_188501_() & branchHeightRand > 0.0f) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, 1, 0), config);
            }
            if ((double)branchHeightRand > (double)random.m_188501_() / 1.5 & branchHeightRand > 0.5f) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, -1, 0), config);
            }
            if (x == 0) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, 0, 0), config);
            }
            this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(v1, 0, v3), config);
            if (x > 1) {
                ret.add(new FoliagePlacer.FoliageAttachment(pos.m_7494_(), 0, false));
            }
            if (x != branchLength - 1) continue;
            this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, -1, 0), config);
        }
    }

    private void addTopBranch(BlockPos blockPos, List<FoliagePlacer.FoliageAttachment> ret, BiConsumer<BlockPos, BlockState> blockSetter, LevelSimulatedReader level, TreeConfiguration config, RandomSource random, int branchOrder) {
        int v1;
        Direction direction = CorruptedGiantTrunkPlacer.computeBranchDir(random);
        BlockPos.MutableBlockPos pos = blockPos.m_121945_(direction).m_122032_();
        BlockPos.MutableBlockPos defaultPos = blockPos.m_121945_(direction).m_122032_();
        int branchLength = branchOrder < 4 ? random.m_216332_(10, 12) : random.m_216332_(7, 9);
        int branchDir = (int)(360.0f / (float)this.f_70265_) * branchOrder;
        int n = branchOrder % 4 == 0 ? 1 : (v1 = branchOrder % 4 == 2 ? -1 : 0);
        int v3 = branchOrder % 4 == 1 ? 1 : (branchOrder % 4 == 3 ? -1 : 0);
        int v4 = branchOrder % 2 == 0 ? 1 : -1;
        for (int x = 0; x < branchLength; ++x) {
            float branchHeightRand = (float)x / (float)branchLength;
            if (branchHeightRand < random.m_188501_() & branchHeightRand > 0.0f) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, 1, 0), config);
            }
            if ((double)branchHeightRand > (double)random.m_188501_() / 1.5 & branchHeightRand > 0.5f) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, -1, 0), config);
            }
            if (x == 0) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, 0, 0), config);
            }
            this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(v1, 0, v3), config);
            if (branchOrder > 3) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(v4 * v3, 0, v4 * v1), config);
            }
            ret.add(new FoliagePlacer.FoliageAttachment(pos.m_7494_(), 0, false));
            if (x != branchLength - 1) continue;
            this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, -1, 0), config);
            ret.add(new FoliagePlacer.FoliageAttachment((BlockPos)pos, 0, false));
        }
    }

    private void addDirt(BlockPos blockPos, List<FoliagePlacer.FoliageAttachment> ret, BiConsumer<BlockPos, BlockState> blockSetter, LevelSimulatedReader level, TreeConfiguration config, RandomSource random, int dirtOrder) {
        int v1;
        int dirtLength = 5;
        BlockPos.MutableBlockPos pos = blockPos.m_7495_().m_122032_();
        int n = dirtOrder % 4 == 0 ? 1 : (v1 = dirtOrder % 4 == 2 ? -1 : 0);
        int v3 = dirtOrder % 4 == 1 ? 1 : (dirtOrder % 4 == 3 ? -1 : 0);
        int v4 = dirtOrder % 2 == 0 ? 1 : -1;
        CorruptedGiantTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos, (TreeConfiguration)config);
        for (int x = 0; x < dirtLength; ++x) {
            CorruptedGiantTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_122184_(v1, 0, v3), (TreeConfiguration)config);
            if (x == 0 && dirtOrder < 4) {
                CorruptedGiantTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_122184_(v1, 0, v3), (TreeConfiguration)config);
            }
            if (dirtOrder > 3 && dirtOrder < 8) {
                CorruptedGiantTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_122184_(v4 * v3, 0, v4 * v1), (TreeConfiguration)config);
            }
            if (dirtOrder <= 7) continue;
            CorruptedGiantTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_122184_(-v4 * v3, 0, -v4 * v1), (TreeConfiguration)config);
        }
    }

    private static Direction computeBranchDir(RandomSource random) {
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        Direction clockAdjusted = random.m_188499_() ? direction.m_122427_() : direction.m_122428_();
        return random.m_188499_() ? direction : clockAdjusted;
    }

    protected boolean m_213554_(LevelSimulatedReader level, BlockPos pos) {
        return true;
    }
}

