/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.corrupted;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CorruptedTrunkPlacer
extends TrunkPlacer {
    public static final Codec<CorruptedTrunkPlacer> CODEC = RecordCodecBuilder.create(p_70161_ -> CorruptedTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)p_70161_).apply((Applicative)p_70161_, CorruptedTrunkPlacer::new));

    public CorruptedTrunkPlacer(int pBaseHeight, int pHeightRandA, int pBranchCount) {
        super(pBaseHeight, pHeightRandA, pBranchCount);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.CORRUPTED_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int pFreeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> ret = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int lastLogHeight = pFreeTreeHeight - (int)Mth.m_216283_((RandomSource)random, (float)2.0f, (float)3.0f);
        BlockPos.MutableBlockPos mainTrunk = pos.m_122032_();
        Object growthDir = null;
        int outerHeight = random.m_188503_(3);
        int cornerHeight = outerHeight + (random.m_188503_(2) - 1);
        int innerHeight = Math.min(outerHeight + random.m_216332_(3, 5), pFreeTreeHeight - 2);
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            this.m_226187_(level, blockSetter, random, (BlockPos)mainTrunk, config);
            if (i == pFreeTreeHeight - 1) {
                for (int branchOrder = 0; branchOrder < this.f_70265_; ++branchOrder) {
                    this.addBranch(mainTrunk.m_7949_(), ret, blockSetter, branchOrder, level, config, random, pFreeTreeHeight);
                }
            }
            if (i == 0) {
                this.fattenTrunk(level, blockSetter, random, pos, config, innerHeight, ret, cornerHeight, outerHeight);
            }
            mainTrunk.m_122173_(Direction.UP);
        }
        return ret;
    }

    private void fattenTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config, int innerHeight, List<FoliagePlacer.FoliageAttachment> ret, int cornerHeight, int outerHeight) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int j;
            if (!(random.m_188500_() <= 0.9)) continue;
            BlockPos blockPosInner = pos.m_121945_(direction);
            for (int j2 = 0; j2 < innerHeight; ++j2) {
                this.m_226187_(level, blockSetter, random, blockPosInner.m_6630_(j2), config);
            }
            if (random.m_188500_() <= 0.9) {
                BlockPos blockPosCorner = blockPosInner.m_121945_(random.m_188500_() > 0.5 ? direction.m_122427_() : direction.m_122428_());
                for (j = 0; j < cornerHeight; ++j) {
                    this.m_226187_(level, blockSetter, random, blockPosCorner.m_6630_(j), config);
                }
            }
            if (!(random.m_188500_() <= 0.9)) continue;
            BlockPos blockPosOuter = blockPosInner.m_121945_(direction);
            for (j = 0; j < outerHeight; ++j) {
                this.m_226187_(level, blockSetter, random, blockPosOuter.m_6630_(j), config);
            }
        }
    }

    private void addBranch(BlockPos blockPos, List<FoliagePlacer.FoliageAttachment> ret, BiConsumer<BlockPos, BlockState> blockSetter, int branchOrder, LevelSimulatedReader level, TreeConfiguration config, RandomSource random, int pFreeTreeHeight) {
        int v1;
        Direction direction = CorruptedTrunkPlacer.computeBranchDir(random);
        BlockPos.MutableBlockPos pos = blockPos.m_121945_(direction).m_122032_();
        BlockPos.MutableBlockPos defaultPos = blockPos.m_121945_(direction).m_122032_();
        int branchLength = Math.min(random.m_216332_(5, 7), pFreeTreeHeight);
        int branchDir = (int)(360.0f / (float)this.f_70265_) * branchOrder;
        int n = branchOrder == 0 ? 1 : (v1 = branchOrder == 2 ? -1 : 0);
        int v3 = branchOrder == 1 ? 1 : (branchOrder == 3 ? -1 : 0);
        for (int x = 0; x < branchLength; ++x) {
            float branchHeightRand = (float)x / (float)branchLength;
            if (branchHeightRand < random.m_188501_() & branchHeightRand > 0.0f) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, 1, 0), config);
            }
            if ((double)branchHeightRand > (double)random.m_188501_() / 1.5 & branchHeightRand > 0.5f) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, -1, 0), config);
            }
            if (x == 0) {
                this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, 0, 0), config);
            }
            this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(v1, 0, v3), config);
            ret.add(new FoliagePlacer.FoliageAttachment(pos.m_7494_(), 0, false));
            if (x != branchLength - 1) continue;
            this.m_226187_(level, blockSetter, random, (BlockPos)pos.m_122184_(0, -1, 0), config);
        }
    }

    private static Direction computeBranchDir(RandomSource random) {
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        Direction clockAdjusted = random.m_188499_() ? direction.m_122427_() : direction.m_122428_();
        return random.m_188499_() ? direction : clockAdjusted;
    }

    protected boolean m_213554_(LevelSimulatedReader level, BlockPos pos) {
        return (Boolean)ModServerConfig.CORRUPTED_TREE_GROW_THROUGH.get() != false || super.m_213554_(level, pos);
    }
}

