/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.Map;
import java.util.Optional;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CaulorflowerBlock
extends Block
implements BonemealableBlock,
ModCropBlock,
Colorable,
Corruptable {
    public CaulorflowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        if (!this.isCorrupted()) {
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ModStateProperties.FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)this.getColorAndEmptyProperties().getA(), (Comparable)DyeColor.WHITE)).m_61124_((Property)this.getColorAndEmptyProperties().getB(), (Comparable)Boolean.valueOf(true))).m_61124_((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean isCorrupted() {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ModStateProperties.FACING, ModStateProperties.FLIPPED, ModStateProperties.SHEARED, this.getAgeProperty(), (Property)this.getColorAndEmptyProperties().getA(), (Property)this.getColorAndEmptyProperties().getB()});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (this.m_7898_(state, (LevelReader)level, currentPos)) {
            return (BlockState)state.m_61124_((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(currentPos.m_123342_() % 2 == 0));
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        if (state.m_60713_((Block)this)) {
            return (BlockState)state.m_61124_((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(context.m_8083_().m_123342_() % 2 == 0));
        }
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(context.m_8083_().m_123342_() % 2 == 0))).m_61124_((Property)ModStateProperties.FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = level.m_8055_(blockPos);
        BlockPos wallPos = pos.m_121945_(((Direction)state.m_61143_((Property)ModStateProperties.FACING)).m_122424_());
        BlockState wallState = level.m_8055_(wallPos);
        return (blockState.m_60713_((Block)ModBlocks.CAULORFLOWER.get()) || blockState.m_60713_((Block)ModBlocks.PATTERNFLOWER.get())) && this.getAge(blockState) > 0 || blockState.m_60783_((BlockGetter)level, blockPos, Direction.UP) || wallState.m_60783_((BlockGetter)level, wallPos, (Direction)state.m_61143_((Property)ModStateProperties.FACING));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
        if ((double)random.m_188501_() < 0.15 && !((Boolean)state.m_61143_((Property)ModStateProperties.SHEARED)).booleanValue()) {
            this.grow(level, pos, false);
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean pIsClient) {
        Optional<BlockPos> highestPos = this.highestPos((BlockGetter)level, pos, true);
        if (highestPos.isPresent()) {
            BlockState blockState = level.m_8055_(highestPos.get());
            return level.m_8055_(highestPos.get().m_7494_()).m_60713_(Blocks.f_50016_) || blockState.m_61138_((Property)this.getAgeProperty()) && !this.isMaxAge(blockState);
        }
        return false;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.grow(level, pos, true);
    }

    protected void grow(ServerLevel level, BlockPos originalPos, boolean bonemeal) {
        if (!this.isMaxAge(level.m_8055_(originalPos))) {
            this.makeGrowOnBonemeal((Level)level, originalPos, level.m_8055_(originalPos));
        } else {
            this.highestPos((BlockGetter)level, originalPos, bonemeal).ifPresent(highestPos -> {
                BlockPos posBelow = highestPos.m_7495_();
                BlockState stateBelow = level.m_8055_(posBelow);
                if (this.isMaxAge(stateBelow)) {
                    level.m_46597_(highestPos, (BlockState)((BlockState)this.m_152465_(stateBelow).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(highestPos.m_123342_() % 2 == 0)));
                } else {
                    this.makeGrowOnBonemeal((Level)level, posBelow, stateBelow);
                }
            });
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.shear(player, level, pos, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (this.harvestable(state)) {
            this.popResource(level, pos, state);
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            BlockState blockstate = (BlockState)state.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(1));
            level.m_7731_(pos, blockstate, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public void popResource(Level level, BlockPos pos, BlockState state) {
        CaulorflowerBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)Dye.stackFromDye(new Dye((DyeColor)state.m_61143_(ModStateProperties.COLOR), 1)));
    }

    public boolean harvestable(BlockState blockState) {
        return this.isMaxAge(blockState) && !this.getDyeFromBlock(blockState).isEmpty();
    }

    public Optional<BlockPos> highestPos(BlockGetter level, BlockPos originalPos, boolean bonemeal) {
        Optional<BlockPos> lowestPos = this.getLowestPos(level, originalPos);
        if (lowestPos.isEmpty()) {
            return Optional.empty();
        }
        Optional<BlockPos> highestPos = this.getLastConnectedBlock(level, lowestPos.get(), Direction.UP);
        return highestPos.filter(blockPos1 -> bonemeal || ((BlockPos)lowestPos.get()).m_123342_() + 5 > blockPos1.m_123342_()).map(BlockPos::m_7494_);
    }

    public Optional<BlockPos> getLowestPos(BlockGetter level, BlockPos originalPos) {
        Optional<BlockPos> posDown = this.getLastConnectedBlock(level, originalPos, Direction.DOWN).map(BlockPos::m_7494_);
        return posDown.filter(blockPos -> level.m_8055_(blockPos).m_60713_((Block)this));
    }

    public Optional<BlockPos> getLastConnectedBlock(BlockGetter pGetter, BlockPos pos, Direction pDirection) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        while (pGetter.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_((Block)this)) {
            blockpos$mutableblockpos.m_122173_(pDirection);
        }
        return pDirection == Direction.DOWN ? Optional.of(blockpos$mutableblockpos) : (pGetter.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_(Blocks.f_50016_) ? Optional.of(blockpos$mutableblockpos.m_7495_()) : Optional.empty());
    }

    public BlockState m_6943_(BlockState state, Mirror pMirror) {
        return state.m_60717_(pMirror.m_54846_((Direction)state.m_61143_((Property)ModStateProperties.FACING)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (newState.m_60713_((Block)this)) {
            return;
        }
        if (newState.m_60713_((Block)ModBlocks.PATTERNFLOWER.get())) {
            return;
        }
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        if (!stateBelow.m_60713_((Block)this) && !stateBelow.m_60713_(Blocks.f_50016_)) {
            CaulorflowerBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.CAULORFLOWER_SEEDS.get()));
        }
        if (!this.isColorEmpty(state) && this.isMaxAge(state)) {
            CaulorflowerBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)Dye.stackFromDye(new Dye((DyeColor)state.m_61143_(ModStateProperties.COLOR), 1)));
        }
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_2;
    }

    @Override
    public void colorBlock(Level level, BlockPos blockPos, BlockState blockState, Dye dye) {
        Colorable.super.colorBlock(level, blockPos, (BlockState)blockState.m_61124_((Property)this.getColorAndEmptyProperties().getB(), (Comparable)Boolean.valueOf(false)), dye);
        Player player = level.m_45924_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 6.0, false);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModAdvancementCritters.USED_DYESPRIA.m_222618_(serverPlayer);
        }
    }

    @Override
    public boolean canBeColored(BlockState blockState, Dye dye) {
        return Colorable.super.canBeColored(blockState, dye) || Colorable.super.isColorEmpty(blockState);
    }

    @Override
    public Map<DyeColor, Integer> colorValues() {
        Map<DyeColor, Integer> map = Colorable.super.colorValues();
        map.put(DyeColor.WHITE, -1);
        map.put(DyeColor.LIGHT_GRAY, -6449253);
        map.put(DyeColor.GRAY, -12103854);
        map.put(DyeColor.BLACK, -14277074);
        map.put(DyeColor.BROWN, -8170446);
        map.put(DyeColor.RED, -2796466);
        map.put(DyeColor.ORANGE, -485835);
        map.put(DyeColor.YELLOW, -4525);
        map.put(DyeColor.LIME, -8337633);
        map.put(DyeColor.GREEN, -10585066);
        map.put(DyeColor.CYAN, -16733492);
        map.put(DyeColor.LIGHT_BLUE, -9381404);
        map.put(DyeColor.BLUE, -12102740);
        map.put(DyeColor.PURPLE, -5152830);
        map.put(DyeColor.MAGENTA, -2984263);
        map.put(DyeColor.PINK, -479036);
        return map;
    }

    @Override
    public void onAddDye(@Nullable ItemStack destinationStack, ItemStack dye, int amount) {
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.onCorruptByEntity(entity, pos, state, this, level);
    }

    @Override
    public void onCorrupt(Level level, BlockPos pos, BlockState oldState, Block corruptedBlock) {
        BlockState corruptedState = corruptedBlock.m_152465_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)corruptedBlock.m_49966_().m_61124_((Property)ModStateProperties.FACING, (Comparable)((Direction)oldState.m_61143_((Property)ModStateProperties.FACING)))).m_61124_((Property)ModStateProperties.FLIPPED, (Comparable)((Boolean)oldState.m_61143_((Property)ModStateProperties.FLIPPED)))).m_61124_((Property)ModStateProperties.AGE_2, (Comparable)((Integer)oldState.m_61143_((Property)ModStateProperties.AGE_2)))).m_61124_(ModStateProperties.BLOCK_PATTERN, (Comparable)((Object)((Boolean)oldState.m_61143_((Property)ModStateProperties.EMPTY) != false ? BlockPattern.EMPTY : BlockPattern.fromDyeColor((DyeColor)oldState.m_61143_(ModStateProperties.COLOR)))))).m_61124_((Property)ModStateProperties.EMPTY, (Comparable)((Boolean)oldState.m_61143_((Property)ModStateProperties.EMPTY))));
        level.m_46597_(pos, corruptedState);
    }
}

