/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.GiantCropBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Bonmeelable;
import net.abraxator.moresnifferflowers.blocks.ModEntityBlock;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraftforge.registries.ForgeRegistries;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import vectorwing.farmersdelight.common.block.RiceBlock;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;

public class GiantCropBlock
extends AbstractMultiBlock
implements ModEntityBlock,
Bonmeelable,
IPreviewableMultiblock,
SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE_POTATO = GiantCropBlock.makeShapePotato();
    public static final VoxelShape SHAPE_CARROT = GiantCropBlock.makeShapeCarrot();
    public static final VoxelShape SHAPE_BEET = GiantCropBlock.makeShapeBeet();
    public static final VoxelShape SHAPE_NETHERWART = GiantCropBlock.makeShapeWart();
    public static final VoxelShape SHAPE_WHEAT = GiantCropBlock.makeShapeWheat();
    public static final VoxelShape SHAPE_ONION = GiantCropBlock.makeShapeOnion();
    public static final VoxelShape SHAPE_TOMATO = GiantCropBlock.makeShapeTomato();
    public static final VoxelShape SHAPE_CABBAGE = GiantCropBlock.makeShapeCabbage();
    public static final VoxelShape SHAPE_RICE = GiantCropBlock.makeShapeRice();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BlockBehaviour.StatePredicate STATE_PREDICATE = (p_152641_, p_152642_, p_152643_) -> (Boolean)p_152641_.m_61143_((Property)ModStateProperties.CENTER);

    public GiantCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ModStateProperties.CENTER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public List<BlockPos> makeFullBlockShape(@Nullable Direction direction, BlockPos center, BlockState blockState) {
        if (this.equals(ModBlocks.GIANT_CABBAGE.get())) {
            return IMultiBlock.posStreamToList((Stream)BlockPos.m_121886_((int)(center.m_123341_() - 1), (int)(center.m_123342_() - 1), (int)(center.m_123343_() - 1), (int)(center.m_123341_() + 1), (int)center.m_123342_(), (int)(center.m_123343_() + 1)));
        }
        return IMultiBlock.posStreamToList((Stream)BlockPos.m_121886_((int)(center.m_123341_() - 1), (int)(center.m_123342_() - 1), (int)(center.m_123343_() - 1), (int)(center.m_123341_() + 1), (int)(center.m_123342_() + 1), (int)(center.m_123343_() + 1)));
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GiantCropBlockEntity) {
            GiantCropBlockEntity entity = (GiantCropBlockEntity)blockEntity;
            if (entity.state == 1) {
                entity.canGrow = true;
            }
        }
    }

    public RenderShape getMultiblockRenderShape(BlockState state) {
        if (!IMultiBlock.isCenter((BlockState)state)) {
            return RenderShape.INVISIBLE;
        }
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean canPlace(LevelReader level, BlockPos center, BlockState state, @Nullable Entity player, boolean ignoreEntities) {
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        return super.m_142598_(level, pos, state);
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (!this.m_49966_().m_204336_(ModTags.ModBlockTags.WATERLOGGABLE)) {
            return false;
        }
        return super.m_6044_(level, pos, state, fluid);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pMovedByPiston) {
        super.m_6807_(state, level, pos, pOldState, pMovedByPiston);
        if (((Boolean)state.m_61143_((Property)ModStateProperties.CENTER)).booleanValue()) {
            level.m_183326_().m_183393_(new ScheduledTick((Object)this, pos, level.m_46467_() + 7L, level.m_183596_()));
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof GiantCropBlockEntity) {
                GiantCropBlockEntity entity = (GiantCropBlockEntity)blockEntity;
                if (entity.state == 0) {
                    entity.state = 1;
                }
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.GIANT_CROP.get()), pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GiantCropBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> pBlockEntityType) {
        return (pLevel1, pos, pState1, blockEntity) -> {
            GiantCropBlockEntity blockEntity1 = (GiantCropBlockEntity)blockEntity;
            if (!blockEntity1.canGrow) {
                return;
            }
            if (!level.f_46443_) {
                blockEntity1.tick(level);
            }
        };
    }

    @Override
    public void performBonmeel(BlockPos blockPos, BlockState blockState, Level level, Player player) {
        if (GiantCropBlock.isRicePanicles(blockState.m_60734_())) {
            blockPos = blockPos.m_7495_();
        }
        BlockPos finalBlockPos = blockPos;
        this.getFullBlockShape(blockPos, blockState, (BlockGetter)level).forEach(pos -> {
            boolean isWaterLogged = level.m_6425_(pos = pos.m_7494_().m_7949_()).m_76152_() == Fluids.f_76193_;
            level.m_46961_(pos, false);
            BlockState state = (BlockState)((BlockState)((Block)GiantCropBlock.getCropMap().get(blockState.m_60734_()).getA()).m_49966_().m_61124_((Property)ModStateProperties.CENTER, (Comparable)Boolean.valueOf(pos.equals((Object)finalBlockPos.m_7494_())))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
            level.m_46597_(pos, state);
            BlockEntity patt9771$temp = level.m_7702_(pos);
            if (patt9771$temp instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)patt9771$temp;
                entity.setCenter(finalBlockPos.m_7494_());
            }
        });
        if (player != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModAdvancementCritters.USED_BONMEEL.m_222618_(serverPlayer);
        }
        level.m_245747_(blockPos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
    }

    @Override
    public boolean canBonmeel(BlockPos blockPos, BlockState blockState, Level level) {
        Block crop = blockState.m_60734_();
        int cropY = blockPos.m_123342_();
        if (GiantCropBlock.isRicePanicles(crop)) {
            blockPos = blockPos.m_7495_();
        }
        return this.getFullBlockShape(blockPos, blockState, (BlockGetter)level).stream().allMatch(pos -> {
            pos = pos.m_7494_();
            BlockState state = level.m_8055_(pos);
            IntegerProperty PROPERTY = (IntegerProperty)((Pair)GiantCropBlock.getCropMap().get(crop).getB()).getA();
            int MAX_AGE = (Integer)((Pair)GiantCropBlock.getCropMap().get(crop).getB()).getB();
            if (pos.m_123342_() == cropY) {
                return state.m_60713_(crop) && state.m_204336_(ModTags.ModBlockTags.BONMEELABLE) && (Integer)state.m_61143_((Property)PROPERTY) == MAX_AGE;
            }
            return state.m_247087_() || state.m_204336_(ModTags.ModBlockTags.GIANT_CROP_REPLACEABLE) || state.m_60713_(crop);
        });
    }

    private static boolean isRicePanicles(Block crop) {
        return crop.equals(BuiltInRegistries.f_256975_.m_7745_(MoreSnifferFlowers.farmersDelightLoc("rice_panicles")));
    }

    private static Map<Block, Pair<Block, Pair<IntegerProperty, Integer>>> cropMapCompat() {
        return Map.of(Blocks.f_50249_, new Pair((Object)((Block)ModBlocks.GIANT_CARROT.get()), (Object)new Pair((Object)CropBlock.f_52244_, (Object)7)), Blocks.f_50250_, new Pair((Object)((Block)ModBlocks.GIANT_POTATO.get()), (Object)new Pair((Object)CropBlock.f_52244_, (Object)7)), Blocks.f_50200_, new Pair((Object)((Block)ModBlocks.GIANT_NETHERWART.get()), (Object)new Pair((Object)NetherWartBlock.f_54967_, (Object)3)), Blocks.f_50444_, new Pair((Object)((Block)ModBlocks.GIANT_BEETROOT.get()), (Object)new Pair((Object)BeetrootBlock.f_49657_, (Object)3)), Blocks.f_50092_, new Pair((Object)((Block)ModBlocks.GIANT_WHEAT.get()), (Object)new Pair((Object)CropBlock.f_52244_, (Object)7)), (Block)ForgeRegistries.BLOCKS.getValue(MoreSnifferFlowers.farmersDelightLoc("onions")), new Pair((Object)((Block)ModBlocks.GIANT_ONION.get()), (Object)new Pair((Object)CropBlock.f_52244_, (Object)7)), (Block)ForgeRegistries.BLOCKS.getValue(MoreSnifferFlowers.farmersDelightLoc("tomatoes")), new Pair((Object)((Block)ModBlocks.GIANT_TOMATO.get()), (Object)new Pair((Object)TomatoVineBlock.VINE_AGE, (Object)3)), (Block)ForgeRegistries.BLOCKS.getValue(MoreSnifferFlowers.farmersDelightLoc("cabbages")), new Pair((Object)((Block)ModBlocks.GIANT_CABBAGE.get()), (Object)new Pair((Object)CropBlock.f_52244_, (Object)7)), (Block)ForgeRegistries.BLOCKS.getValue(MoreSnifferFlowers.farmersDelightLoc("rice_panicles")), new Pair((Object)((Block)ModBlocks.GIANT_RICE.get()), (Object)new Pair((Object)RiceBlock.AGE, (Object)3)));
    }

    private static Map<Block, Pair<Block, Pair<IntegerProperty, Integer>>> cropMapVanilla() {
        return Map.of(Blocks.f_50249_, new Pair((Object)((Block)ModBlocks.GIANT_CARROT.get()), (Object)new Pair((Object)CropBlock.f_52244_, (Object)7)), Blocks.f_50250_, new Pair((Object)((Block)ModBlocks.GIANT_POTATO.get()), (Object)new Pair((Object)CropBlock.f_52244_, (Object)7)), Blocks.f_50200_, new Pair((Object)((Block)ModBlocks.GIANT_NETHERWART.get()), (Object)new Pair((Object)NetherWartBlock.f_54967_, (Object)3)), Blocks.f_50444_, new Pair((Object)((Block)ModBlocks.GIANT_BEETROOT.get()), (Object)new Pair((Object)BeetrootBlock.f_49657_, (Object)3)), Blocks.f_50092_, new Pair((Object)((Block)ModBlocks.GIANT_WHEAT.get()), (Object)new Pair((Object)CropBlock.f_52244_, (Object)7)));
    }

    public static Map<Block, Pair<Block, Pair<IntegerProperty, Integer>>> getCropMap() {
        return MoreSnifferFlowers.hasFarmersDelight() ? GiantCropBlock.cropMapCompat() : GiantCropBlock.cropMapVanilla();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83144_();
        if (IMultiBlock.getXOffset((BlockGetter)getter, (BlockPos)pos) == 0 && IMultiBlock.getZOffset((BlockGetter)getter, (BlockPos)pos) == 0) {
            return shape;
        }
        if (this.equals(ModBlocks.GIANT_POTATO.get())) {
            shape = SHAPE_POTATO;
        }
        if (this.equals(ModBlocks.GIANT_CARROT.get())) {
            shape = SHAPE_CARROT;
        }
        if (this.equals(ModBlocks.GIANT_BEETROOT.get())) {
            shape = SHAPE_BEET;
        }
        if (this.equals(ModBlocks.GIANT_NETHERWART.get())) {
            shape = SHAPE_NETHERWART;
        }
        if (this.equals(ModBlocks.GIANT_WHEAT.get())) {
            shape = SHAPE_WHEAT;
        }
        if (this.equals(ModBlocks.GIANT_ONION.get())) {
            shape = SHAPE_ONION;
        }
        if (this.equals(ModBlocks.GIANT_TOMATO.get())) {
            shape = SHAPE_TOMATO;
        }
        if (this.equals(ModBlocks.GIANT_CABBAGE.get())) {
            shape = SHAPE_CABBAGE;
        }
        if (this.equals(ModBlocks.GIANT_RICE.get())) {
            shape = SHAPE_RICE;
        }
        return this.voxelShapeHelper(state, getter, pos, shape, 0.0f, -1.0f, 0.0f);
    }

    public static VoxelShape makeShapePotato() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.4375, (double)-0.0625, (double)-0.4375, (double)1.4375, (double)2.125, (double)1.4375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.3125, (double)2.125, (double)-0.3125, (double)1.3125, (double)2.375, (double)1.3125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeWheat() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.5625, (double)-0.0625, (double)-0.5625, (double)1.5625, (double)2.9375, (double)1.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeCarrot() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.6875, (double)-0.0625, (double)-0.6875, (double)1.6875, (double)0.4375, (double)1.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.4375, (double)0.375, (double)-0.4375, (double)1.4375, (double)1.875, (double)1.4375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeWart() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.5625, (double)1.25, (double)-0.5625, (double)1.5625, (double)3.0, (double)1.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.125, (double)0.0, (double)-0.125, (double)1.125, (double)1.25, (double)1.125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeBeet() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.375, (double)-0.0625, (double)-0.375, (double)1.375, (double)1.75, (double)1.375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeCabbage() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.5625, (double)0.0, (double)-0.5625, (double)1.5625, (double)1.5, (double)1.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeOnion() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.33, (double)0.0, (double)-0.325, (double)1.3, (double)2.0, (double)1.3), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeTomato() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.437, (double)-0.0625, (double)-0.405, (double)1.4375, (double)1.8125, (double)1.465), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeRice() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)2.5, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.1875, (double)-0.0625, (double)-0.1875, (double)1.1875, (double)0.8125, (double)1.1875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }
}

