/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.blockentities.SaltemoneBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModEntityBlock;
import net.abraxator.moresnifferflowers.blocks.multiblock.ICorruptableMultiblock;
import net.abraxator.moresnifferflowers.entities.SaltBubbleProjectile;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.SaltemoneParticlePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import org.jetbrains.annotations.Nullable;

public class SaltemoneBlock
extends AbstractMultiBlock
implements ModEntityBlock,
Corruptable,
ModCropBlock,
IPreviewableMultiblock,
ICorruptableMultiblock {
    protected static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public SaltemoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ModStateProperties.CENTER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Block getCorruptedBlock() {
        return (Block)ModBlocks.SOURLEMONE.get();
    }

    @Override
    public Block getCuredBlock() {
        return (Block)ModBlocks.SALTEMONE.get();
    }

    public BlockState getDefaultStateForPreviews(Direction direction) {
        return (BlockState)super.getDefaultStateForPreviews(direction).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.getAgeProperty(), ModStateProperties.SHEARED});
    }

    public RenderShape getMultiblockRenderShape(BlockState state) {
        if (!IMultiBlock.isCenter((BlockState)state)) {
            return RenderShape.INVISIBLE;
        }
        if (this.getAge(state) == this.getMaxAge()) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return RenderShape.MODEL;
    }

    public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state) {
        return !level.m_46801_(pos) && level.m_46801_(pos.m_7495_());
    }

    @Nullable
    public DirectionProperty getDirectionProperty() {
        return HorizontalDirectionalBlock.f_54117_;
    }

    public List<BlockPos> makeFullBlockShape(@Nullable Direction direction, BlockPos center, BlockState blockState) {
        BlockPos relative = center.m_121945_(direction).m_121945_(direction.m_122427_());
        return IMultiBlock.posStreamToList((Stream)BlockPos.m_121921_((AABB)new AABB(center, relative)));
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_2;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean pIsClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growHelper((Level)level, pos, this.getAgeProperty());
    }

    public boolean isCorrupted() {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.shear(player, level, pos, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)ModStateProperties.SHEARED)).booleanValue()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SaltemoneBlockEntity) {
            SaltemoneBlockEntity entity = (SaltemoneBlockEntity)blockEntity;
            if (pos.equals((Object)entity.center)) {
                if (this.isMaxAge(state)) {
                    Direction direction = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                    Vec3 vec3 = entity.center.m_252807_().m_231075_(direction, 0.5).m_231075_(direction.m_122427_(), 0.5).m_231075_(Direction.UP, 0.0);
                    float speed = 0.2f;
                    SaltBubbleProjectile projectile = new SaltBubbleProjectile(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (Level)level);
                    projectile.m_20242_(true);
                    projectile.setCorrupted(this.isCorrupted());
                    projectile.setState(0);
                    projectile.m_20334_(((double)random.m_188501_() - 0.5) * (double)speed, 1.0f * speed, ((double)random.m_188501_() - 0.5) * (double)speed);
                    level.m_7967_((Entity)projectile);
                    ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SaltemoneParticlePacket(vec3.m_252839_()));
                } else if (IMultiBlock.isCenter((BlockState)state)) {
                    this.growHelper((Level)level, pos, this.getAgeProperty());
                }
            }
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entityinside) {
        this.corruptionHelper(state, level, pos, entityinside);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new SaltemoneBlockEntity(blockPos, blockState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }
}

