/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.cropressor;

import net.abraxator.moresnifferflowers.blockentities.CropressorBlockEntity;
import net.abraxator.moresnifferflowers.blocks.cropressor.CropressorBlockOut;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CropressorBlockBase
extends HorizontalDirectionalBlock {
    public final Part PART;
    protected BlockPos ENTITY_POS;
    protected static final VoxelShape OUT_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape OUT_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape OUT_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape OUT_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape CENTER_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape CENTER_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape CENTER_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    protected static final VoxelShape CENTER_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);

    public CropressorBlockBase(BlockBehaviour.Properties properties, Part part) {
        super(properties);
        this.PART = part;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = CropressorBlockBase.getConnectedDirection(state);
        if (state.m_60734_() instanceof CropressorBlockOut) {
            return switch (direction) {
                case Direction.EAST -> OUT_EAST;
                case Direction.SOUTH -> OUT_SOUTH;
                case Direction.WEST -> OUT_WEST;
                default -> OUT_NORTH;
            };
        }
        return switch (direction) {
            case Direction.EAST -> CENTER_EAST;
            case Direction.SOUTH -> CENTER_SOUTH;
            case Direction.WEST -> CENTER_WEST;
            default -> CENTER_NORTH;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, ModStateProperties.FULLNESS});
    }

    private Direction getNeighbourDirection(Part part, Direction direction) {
        return part == Part.OUT ? direction : direction.m_122424_();
    }

    public BlockState m_7417_(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor level, BlockPos currentPos, BlockPos pNeighborPos) {
        if (pDirection == this.getNeighbourDirection(this.PART, (Direction)state.m_61143_((Property)f_54117_))) {
            boolean b1;
            boolean b = pNeighborState.m_60734_() instanceof CropressorBlockBase;
            boolean bl = b1 = CropressorBlockBase.getPartFromState(pNeighborState) != this.PART;
            if (b && b1) {
                return super.m_7417_(state, pDirection, pNeighborState, level, currentPos, pNeighborPos);
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, pDirection, pNeighborState, level, currentPos, pNeighborPos);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return ((Item)ModItems.CROPRESSOR.get()).m_7968_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos blockPos = context.m_8083_();
        BlockPos blockPos1 = blockPos.m_121945_(direction);
        Level level = context.m_43725_();
        return level.m_8055_(blockPos1).m_60629_(context) && level.m_6857_().m_61937_(blockPos1) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return CropressorBlockBase.getPartFromState(state) == Part.CENTER ? direction.m_122424_() : direction;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_) {
            BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            level.m_7731_(blockPos, (BlockState)((Block)ModBlocks.CROPRESSOR_CENTER.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_))), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CropressorBlockEntity entity;
        BlockEntity blockEntity;
        this.ENTITY_POS = CropressorBlockBase.getEntityPos((BlockAndTintGetter)level, pos, this.PART);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(this.ENTITY_POS)) instanceof CropressorBlockEntity && (entity = (CropressorBlockEntity)blockEntity).canInteract() && player.m_21205_().m_204117_(ModTags.ModItemTags.CROPRESSABLE)) {
            return entity.addItem(player.m_21120_(hand));
        }
        return InteractionResult.FAIL;
    }

    public static BlockPos getEntityPos(BlockAndTintGetter level, BlockPos blockPos, Part part) {
        if (part == Part.OUT) {
            return blockPos;
        }
        BlockState state = level.m_8055_(blockPos);
        return blockPos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
    }

    public static Part getPartFromState(BlockState blockState) {
        Part part;
        Block block = blockState.m_60734_();
        if (block instanceof CropressorBlockBase) {
            CropressorBlockBase baseCropressorBlock = (CropressorBlockBase)block;
            part = baseCropressorBlock.PART;
        } else {
            part = null;
        }
        return part;
    }

    public static enum Part implements StringRepresentable
    {
        CENTER("center"),
        OUT("out");

        public static final StringRepresentable.EnumCodec<DyeColor> CODEC;
        private String name;

        private Part(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(DyeColor::values);
        }
    }
}

