/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.xbush;

import java.util.Optional;
import net.abraxator.moresnifferflowers.blockentities.XbushBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModEntityDoubleTallBlock;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXBushBlockBase
extends ModEntityDoubleTallBlock
implements ModCropBlock,
Corruptable {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final int AGE_TO_GROW_UP = 4;

    public AbstractXBushBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_8;
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity;
        if (this.isUpper(state) && (blockEntity = level.m_7702_(pos)) instanceof XbushBlockEntity) {
            XbushBlockEntity entity = (XbushBlockEntity)blockEntity;
            if (entity.hasGrown) {
                return super.m_5940_(state, level, pos, context);
            }
        }
        return SHAPE;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(level.m_8055_(pos.m_7495_())) && this.sufficientLight(level, pos) && super.m_7898_(state, level, pos);
    }

    @Override
    public boolean mayPlaceOn(BlockState state) {
        return ModCropBlock.super.mayPlaceOn(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ModStateProperties.AGE_8});
        builder.m_61104_(new Property[]{ModStateProperties.SHEARED});
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && level.m_46469_().m_46207_(GameRules.f_46132_)) {
            level.m_46953_(pos, true, entity);
        }
        this.onCorruptByEntity(entity, pos, state, this, level);
        super.m_7892_(state, level, pos, entity);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext pUseContext) {
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.getAge(state) == 7 && random.m_188503_(100) < 10 && this.isLower(state)) {
            level.m_6485_((ParticleOptions)ModParticles.AMBUSH.get(), true, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + random.m_188500_() + random.m_188500_(), (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)ModStateProperties.SHEARED)).booleanValue()) {
            return;
        }
        float f = ModCropBlock.getGrowthSpeed(state, (BlockGetter)level, pos);
        if (random.m_188503_((int)(25.0f / f + 1.0f)) == 0) {
            this.grow(level, state, pos, 1);
        }
    }

    public void grow(ServerLevel level, BlockState state, BlockPos pos, int i) {
        int k = Math.min(this.getAge(state) + i, this.getMaxAge());
        if (this.canGrow((LevelReader)level, pos, state, k) && level.m_213780_().m_188501_() < 0.6f) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(k)), 2);
            if (k >= 4 && this.isLower(state)) {
                level.m_7731_(pos.m_7494_(), (BlockState)this.getUpperBlock().m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(k)), 3);
            }
            this.getLowerHalf((LevelReader)level, pos, state).ifPresent(posAndState -> {
                BlockEntity patt5938$temp = level.m_7702_(posAndState.blockPos().m_7494_());
                if (patt5938$temp instanceof XbushBlockEntity) {
                    XbushBlockEntity entity = (XbushBlockEntity)patt5938$temp;
                    entity.growProgress = 0.0f;
                }
            });
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.shear(player, level, pos, hand)) {
            return InteractionResult.SUCCESS;
        }
        Optional<ModCropBlock.PosAndState> optional = this.getLowerHalf((LevelReader)level, pos, state);
        ItemStack stack = player.m_21120_(hand);
        if (!this.isMaxAge(state) && stack.m_150930_(Items.f_42499_) || optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(optional.get().blockPos().m_7494_());
        if (blockEntity instanceof XbushBlockEntity) {
            XbushBlockEntity entity = (XbushBlockEntity)blockEntity;
            if (entity.hasGrown) {
                BlockPos lowerPos = this.isLower(state) ? pos : pos.m_7495_();
                AbstractXBushBlockBase.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getDropBlock()));
                level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                for (int i = 0; i <= 1; ++i) {
                    BlockPos halfPos = i == 0 ? lowerPos : lowerPos.m_7494_();
                    BlockState stateNew = (BlockState)level.m_8055_(halfPos).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(7));
                    level.m_7731_(halfPos, stateNew, 3);
                    level.m_220407_(GameEvent.f_157792_, halfPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)stateNew));
                }
                entity.reset();
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    private boolean canGrowInto(BlockState state) {
        return state.m_60795_() || state.m_60713_(this.getUpperBlock());
    }

    private boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos);
    }

    @Override
    public int getMaxAge() {
        return ModCropBlock.super.getMaxAge() - 1;
    }

    private boolean canGrow(LevelReader level, BlockPos pos, BlockState state, int k) {
        return !this.isMaxAge(state) && this.sufficientLight(level, pos) && (k < 4 || this.canGrowInto(level.m_8055_(pos.m_7494_()))) && this.isLower(state);
    }

    @Override
    public void onCorrupt(Level level, BlockPos pos, BlockState oldState, Block corruptedBlock) {
        Optional<ModCropBlock.PosAndState> lowerHalf = this.getLowerHalf((LevelReader)level, pos, oldState);
        lowerHalf.ifPresent(posAndState -> {
            level.m_46597_(posAndState.blockPos(), corruptedBlock.m_152465_(oldState));
            if (this.getAge(((ModCropBlock.PosAndState)lowerHalf.get()).state()) > 3) {
                this.getCorruptedBlock(this.getUpperBlock(), level).ifPresent(block -> level.m_46597_(posAndState.blockPos().m_7494_(), block.m_152465_(level.m_8055_(posAndState.blockPos().m_7494_()))));
            }
        });
    }

    Optional<ModCropBlock.PosAndState> getLowerHalf(LevelReader level, BlockPos blockPos, BlockState state) {
        if (this.isLower(state)) {
            return Optional.of(new ModCropBlock.PosAndState(blockPos, state));
        }
        BlockPos posBelow = blockPos.m_7495_();
        BlockState stateBelow = level.m_8055_(posBelow);
        return this.isLower(stateBelow) ? Optional.of(new ModCropBlock.PosAndState(posBelow, stateBelow)) : Optional.empty();
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean pIsClient) {
        Optional<ModCropBlock.PosAndState> posAndState = this.getLowerHalf(level, pos, state);
        return posAndState.isPresent() && this.canGrow(level, posAndState.get().blockPos(), posAndState.get().state(), this.getAge(posAndState.get().state()) + 1);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.getLowerHalf((LevelReader)level, pos, state).ifPresent(posAndState -> {
            if ((Integer)state.m_61143_((Property)ModStateProperties.AGE_8) < 8) {
                this.grow(level, posAndState.state(), posAndState.blockPos(), 1);
            }
        });
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public abstract Block getDropBlock();
}

