/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.SyncGluedPacket;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GluedCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public boolean isGlued;
    private final LazyOptional<GluedCapability> optional = LazyOptional.of(() -> this);
    public static final ResourceLocation ID = MoreSnifferFlowers.loc("is_glued");

    public static void setAndSync(LivingEntity entity, boolean isGlued, boolean playSound) {
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (playSound) {
            GluedCapability.playSound(level, (Entity)entity);
        }
        entity.getCapability(CapabilityList.GLUED).ifPresent(cap -> {
            cap.isGlued = isGlued;
            cap.sync(entity);
        });
    }

    public void sync(LivingEntity entity) {
        GluedCapability.sync(entity, this.isGlued);
    }

    public static void sync(LivingEntity entity, boolean isGlued) {
        ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncGluedPacket(isGlued, entity.m_19879_()));
    }

    public static void playSound(Level level, Entity entity) {
        level.m_5594_(null, entity.m_20097_(), SoundEvents.f_11773_, SoundSource.PLAYERS, 5.0f, 0.02f + level.f_46441_.m_188501_() * 0.01f);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityList.GLUED.orEmpty(cap, this.optional.cast());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("isGlued", this.isGlued);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.isGlued = tag.m_128471_("isGlued");
    }
}

