/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import java.util.UUID;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.SyncSlipperyPacket;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlipperyCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final UUID ATTRIBUTE_ID = UUID.fromString("41DD0153-E92A-B00B-9800-EFFEC5511BB1");
    private final LazyOptional<SlipperyCapability> optional = LazyOptional.of(() -> this);
    public static final ResourceLocation ID = MoreSnifferFlowers.loc("slippery");
    public float lastYaw = 0.0f;
    public float lastSpeed = 0.0f;
    public boolean isFallen = false;
    public int fallenTicks = 0;
    public int maxFallenTicks = 0;

    public void onEffectEnd(Player player) {
        this.lastSpeed = 0.0f;
        this.lastYaw = 0.0f;
        if (this.isFallen) {
            this.getUp(player);
        }
    }

    public void tick(Player player, int amplifier) {
        float yaw = player.m_146908_();
        Vec3 motion = player.m_20184_();
        float speed = (float)(motion.f_82479_ + motion.f_82480_ + motion.f_82481_);
        if (this.isFallen) {
            --this.fallenTicks;
            player.m_6862_(false);
            player.m_20334_(motion.f_82479_, Math.min(motion.f_82480_, 0.0), motion.f_82481_);
            if (!player.m_20089_().equals((Object)Pose.SWIMMING)) {
                player.setForcedPose(Pose.SWIMMING);
            }
            if (this.fallenTicks <= 0) {
                this.getUp(player);
            }
        } else if (!(player.m_9236_().f_46443_ || this.lastSpeed == 0.0f && this.lastYaw == 0.0f)) {
            boolean rotationChange;
            boolean speedChange = Math.abs(speed - this.lastSpeed) > 0.6f;
            float rotationLimit = Math.max(90.0f - (float)(amplifier * 10), 15.0f);
            boolean bl = rotationChange = Math.abs(Mth.m_14177_((float)(yaw - this.lastYaw))) > rotationLimit && player.m_20142_();
            if (player.m_20096_() && (speedChange || rotationChange)) {
                this.fallDown(player, amplifier);
            }
        }
        this.lastSpeed = speed;
        this.lastYaw = yaw;
    }

    public void fallDown(Player player, int amplifier) {
        this.isFallen = true;
        this.fallenTicks = this.maxFallenTicks = 30 + amplifier * 10;
        player.m_21051_(Attributes.f_22279_).m_22120_(ATTRIBUTE_ID);
        AttributeModifier mod = new AttributeModifier(ATTRIBUTE_ID, "slippery", -100.0, AttributeModifier.Operation.ADDITION);
        player.m_21051_(Attributes.f_22279_).m_22118_(mod);
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12388_, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.sync(player);
    }

    public void getUp(Player player) {
        this.fallenTicks = 0;
        this.isFallen = false;
        player.m_21051_(Attributes.f_22279_).m_22120_(ATTRIBUTE_ID);
        player.setForcedPose(null);
        if (!player.m_9236_().f_46443_) {
            this.sync(player);
        }
    }

    public void sync(Player player) {
        ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncSlipperyPacket(this.isFallen, player.m_19879_(), this.fallenTicks, this.maxFallenTicks));
    }

    public static SlipperyCapability get(Player player) {
        return (SlipperyCapability)player.getCapability(CapabilityList.SLIPPERY).orElseThrow(IllegalStateException::new);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityList.SLIPPERY.orEmpty(cap, this.optional.cast());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("lastYaw", this.lastYaw);
        tag.m_128350_("lastSpeed", this.lastSpeed);
        tag.m_128379_("isFallen", this.isFallen);
        tag.m_128405_("fallenTicks", this.fallenTicks);
        tag.m_128405_("maxFallenTicks", this.maxFallenTicks);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.lastYaw = nbt.m_128457_("lastYaw");
        this.lastSpeed = nbt.m_128457_("lastSpeed");
        this.isFallen = nbt.m_128471_("isFallen");
        this.fallenTicks = nbt.m_128451_("fallenTicks");
        this.maxFallenTicks = nbt.m_128451_("maxFallenTicks");
    }
}

