/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.gui.screen;

import java.util.Optional;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.client.gui.menu.RebrewingStandMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RebrewingStandScreen
extends AbstractContainerScreen<RebrewingStandMenu> {
    public static final ResourceLocation TEXTURE = MoreSnifferFlowers.loc("textures/gui/container/rebrewing_stand.png");
    private static final int[] BUBBLELENGTHS = new int[]{0, 5, 8, 12, 17, 22, 27};

    public RebrewingStandScreen(RebrewingStandMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.renderOnboardingTooltips(guiGraphics, mouseX, mouseY, x, y);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int fuel = ((RebrewingStandMenu)this.f_97732_).getFuel();
        int progress = ((RebrewingStandMenu)this.f_97732_).getBrewingTicks();
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (((RebrewingStandMenu)this.f_97732_).getCost() <= 16) {
            String cost = String.valueOf(((RebrewingStandMenu)this.f_97732_).getCost());
            int color = Minecraft.m_91087_().m_91098_().m_7536_().anyMatch(packResources -> packResources.m_5542_().equals("more_sniffer_flowers_boring")) ? 0xC6C6C6 : 9649229;
            int colorOutline = Minecraft.m_91087_().m_91098_().m_7536_().anyMatch(packResources -> packResources.m_5542_().equals("more_sniffer_flowers_boring")) ? 0x373737 : 6169167;
            this.drawCost(guiGraphics, cost, x, y, colorOutline, -1, 0);
            this.drawCost(guiGraphics, cost, x, y, colorOutline, 1, 0);
            this.drawCost(guiGraphics, cost, x, y, colorOutline, 0, -1);
            this.drawCost(guiGraphics, cost, x, y, colorOutline, 0, 1);
            this.drawCost(guiGraphics, cost, x, y, color, 0, 0);
        } else {
            guiGraphics.m_280218_(TEXTURE, x + 30, y + 45, 197, 0, 19, 11);
        }
        if (fuel > 0) {
            int renderFuel = -(fuel * 2);
            guiGraphics.m_280218_(TEXTURE, x + 57, y + 42, 209, 40, renderFuel, -11);
        }
        if (progress > 0) {
            int arrowScale = (int)Mth.m_14179_((float)((float)progress / 100.0f), (float)0.0f, (float)27.0f);
            guiGraphics.m_280218_(TEXTURE, x + 124, y + 18, 177, 1, 8, arrowScale);
            int bubbleFactor = BUBBLELENGTHS[progress / 2 % 7];
            guiGraphics.m_280218_(TEXTURE, x + 58, y + 37 - bubbleFactor, 186, 28 - bubbleFactor, 11, bubbleFactor);
        }
    }

    public void renderOnboardingTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        Optional<Component> optional = Optional.empty();
        if (RebrewingStandScreen.isMouseOver(mouseX, mouseY, x + 24, y + 31, 33, 11)) {
            guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)(((RebrewingStandMenu)this.f_97732_).getFuel() + "/16")), 115), mouseX, mouseY);
        }
        if (this.f_97734_ != null && !this.f_97734_.m_6657_()) {
            switch (this.f_97734_.f_40219_) {
                case 0: {
                    optional = Optional.of(this.component("fuel", "Add Cropressed Nether Wart"));
                    break;
                }
                case 1: {
                    optional = Optional.of(this.component("og_potion", "Add Extracted Potion"));
                    break;
                }
                case 2: {
                    optional = Optional.of(this.component("ingredient", "Add Ingredient"));
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    optional = Optional.of(this.component("potion", "Add Water Bottle"));
                    break;
                }
                default: {
                    return;
                }
            }
        }
        optional.ifPresent(component -> guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)component, 115), mouseX, mouseY));
    }

    private void drawCost(GuiGraphics guiGraphics, String cost, int x, int y, int color, int xOffset, int yOffset) {
        this.f_96547_.m_272078_(cost, (float)(x + 40 - this.f_96547_.m_92895_(cost) / 2 + xOffset), (float)(y + 46 + yOffset), color, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0, this.f_96547_.m_92718_());
    }

    private Component component(String id, String fallback) {
        return Component.m_264568_((String)("tooltip.moresnifferflowers.rebrewing_stand." + id), (String)fallback);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)x && mouseX <= (double)(x + sizeX) && mouseY >= (double)y && mouseY <= (double)(y + sizeY);
    }
}

