/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DyespriaPlantBlockEntityRenderer
implements BlockEntityRenderer<DyespriaPlantBlockEntity> {
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final ModelPart modelPart;

    public DyespriaPlantBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderDispatcher = context.m_234446_();
        this.modelPart = context.m_173582_(ModModelLayerLocations.DYESPRIA);
    }

    public void render(DyespriaPlantBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean hasDye;
        BlockState state = blockEntity.m_58900_();
        boolean isGrown = (Integer)state.m_61143_((Property)ModStateProperties.AGE_3) >= 3;
        Dye dye = blockEntity.dye;
        boolean bl = hasDye = !dye.isEmpty();
        if (isGrown) {
            boolean isModdedDye = Colorable.isModdedDye(dye.color());
            boolean hasInvalidDye = dye.isEmpty() || isModdedDye;
            String colorName = hasInvalidDye ? "white" : dye.color().m_41065_();
            Material TEXTURE = new Material(TextureAtlas.f_118259_, MoreSnifferFlowers.loc("block/dyespria/dyespria_top_" + colorName));
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            poseStack.m_85837_(0.5, -1.5, -0.5);
            if (DyespriaPlantBlockEntityRenderer.isRotated(blockEntity.m_58899_())) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            }
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (isModdedDye) {
                float[] rgb = ModColorHandler.hexToRGB(dye.color().m_41071_());
                r = rgb[0];
                g = rgb[1];
                b = rgb[2];
            }
            this.modelPart.m_104306_(poseStack, TEXTURE.m_119194_(buffer, RenderType::m_110452_), packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
            poseStack.m_85849_();
        }
        if (isGrown && hasDye && !((Boolean)state.m_61143_((Property)ModStateProperties.SHEARED)).booleanValue()) {
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            DyeItem dyeItem = DyeItem.m_41082_((DyeColor)((DyeColor)state.m_61143_(ModStateProperties.COLOR)));
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.9375, 0.5);
            poseStack.m_252781_(this.entityRenderDispatcher.m_253208_());
            poseStack.m_85841_(0.35f, 0.35f, 0.35f);
            itemRenderer.m_269128_(new ItemStack((ItemLike)dyeItem), ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.m_58904_(), (int)blockEntity.m_58899_().m_121878_());
            poseStack.m_85849_();
        }
    }

    public static boolean isRotated(BlockPos pos) {
        long total = pos.m_123341_() + pos.m_123342_() + pos.m_123343_();
        return total % 2L == 0L;
    }
}

