/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.abraxator.moresnifferflowers.client.gui.screen.RebrewingStandScreen;
import net.abraxator.moresnifferflowers.compat.jei.corruption.CorruptionCategory;
import net.abraxator.moresnifferflowers.compat.jei.cropressing.CropressingRecipeCategory;
import net.abraxator.moresnifferflowers.compat.jei.rebrewing.JeiRebrewingRecipe;
import net.abraxator.moresnifferflowers.compat.jei.rebrewing.RebrewingCategory;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModRecipeTypes;
import net.abraxator.moresnifferflowers.recipes.CorruptionRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class MoreSnifferFlowersJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("jei", "moresnifferflowers");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)ModItems.CROPRESSOR.get()).m_7968_(), new RecipeType[]{CropressingRecipeCategory.CROPRESSING});
        registration.addRecipeCatalyst(((Item)ModItems.REBREWING_STAND.get()).m_7968_(), new RecipeType[]{RebrewingCategory.REBREWING});
        registration.addRecipeCatalyst(((Item)ModItems.CORRUPTED_SLIME_BALL.get()).m_7968_(), new RecipeType[]{CorruptionCategory.CORRUPTION});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(RebrewingStandScreen.class, 123, 17, 9, 28, new RecipeType[]{RebrewingCategory.REBREWING});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CropressingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RebrewingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CorruptionCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        ArrayList cropressingRecipes = new ArrayList(recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CROPRESSING.get()));
        ArrayList<CorruptionRecipe> corruptionRecipes = new ArrayList<CorruptionRecipe>(recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CORRUPTION.get()));
        for (Map.Entry<Block, Block> entry : CorruptionRecipe.HARDCODED_BLOCK.entrySet()) {
            ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)entry.getKey());
            corruptionRecipes.add(new CorruptionRecipe(id, id.toString(), List.of(new CorruptionRecipe.Entry(entry.getValue(), 100))));
        }
        registration.addRecipes(CropressingRecipeCategory.CROPRESSING, cropressingRecipes);
        registration.addRecipes(RebrewingCategory.REBREWING, JeiRebrewingRecipe.createRecipes());
        registration.addRecipes(CorruptionCategory.CORRUPTION, corruptionRecipes);
    }
}

