/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.compat.jei.corruption;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.recipes.CorruptionRecipe;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class CorruptionCategory
implements IRecipeCategory<CorruptionRecipe> {
    public static final RecipeType<CorruptionRecipe> CORRUPTION = RecipeType.create((String)"moresnifferflowers", (String)"corruption", CorruptionRecipe.class);
    private final IDrawable icon;
    private final Component localizedName;

    public CorruptionCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableItemStack(((Item)ModItems.CORRUPTED_SLIME_BALL.get()).m_7968_());
        this.localizedName = Component.m_264568_((String)"gui.moresnifferflowers.corrupting_category", (String)"Corrupting");
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 40;
    }

    public RecipeType<CorruptionRecipe> getRecipeType() {
        return CORRUPTION;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CorruptionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.m_280218_(MoreSnifferFlowers.loc("textures/gui/container/corrupting_jei.png"), 0, 0, 0, 0, this.getWidth(), this.getHeight());
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CorruptionRecipe recipe, IFocusGroup focuses) {
        if (recipe.tagOrBlock()) {
            TagKey<Block> tagKey = recipe.inputTag().get();
            List<ItemStack> items = StreamSupport.stream(BuiltInRegistries.f_256975_.m_206058_(tagKey).spliterator(), false).map(Holder::get).filter(block -> !block.m_49966_().m_204336_(ModTags.ModBlockTags.UNCORRUPTABLE)).map(block -> block.m_5456_().m_7968_()).filter(itemStack -> !itemStack.m_41619_()).toList();
            builder.addSlot(RecipeIngredientRole.INPUT, 10, 15).addItemStacks(items);
        } else if (!recipe.inputBlock().get().m_49966_().m_204336_(ModTags.ModBlockTags.UNCORRUPTABLE)) {
            builder.addSlot(RecipeIngredientRole.INPUT, 10, 15).addItemStack(recipe.inputBlock().get().m_5456_().m_7968_());
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 15).addItemStacks(recipe.list().stream().map(entry -> entry.block().m_5456_().m_7968_()).collect(Collectors.toList()))).addRichTooltipCallback((recipeSlotView, tooltip) -> {
            Map map = (Map)Util.m_137469_((Object)Maps.newHashMap(), o -> recipe.list().stream().map(entry -> Map.entry(entry.block().m_5456_().m_7968_(), entry.weight())).forEach(entry -> o.put(((ItemStack)entry.getKey()).m_41720_(), (Integer)entry.getValue())));
            float weight = 100.0f;
            int totalWeight = recipe.list().stream().mapToInt(CorruptionRecipe.Entry::weight).sum();
            Optional current = recipeSlotView.getDisplayedItemStack();
            if (current.isPresent()) {
                weight = map.getOrDefault(((ItemStack)current.get()).m_41720_(), -5).intValue();
            }
            float percentage = Math.round(weight / (float)totalWeight * 100.0f);
            tooltip.add(FormattedText.m_130775_((String)("Chance: " + percentage + "%")));
        });
    }
}

