/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record Dye(DyeColor color, int amount) {
    public static final Codec<Dye> CODEC = RecordCodecBuilder.create(dyeInstance -> dyeInstance.group((App)Codec.INT.fieldOf("color").forGetter(Dye::colorId), (App)Codec.INT.fieldOf("amount").forGetter(Dye::amount)).apply((Applicative)dyeInstance, (colorId, amount) -> new Dye(Dye.colorFromId(colorId), (int)amount)));
    public static final Dye EMPTY = new Dye(DyeColor.WHITE, 0);

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public static Dye getDyeFromDyeStack(ItemStack dyeStack) {
        return new Dye(((DyeItem)dyeStack.m_41720_()).m_41089_(), dyeStack.m_41613_());
    }

    public static Dye getDyeFromDyespria(ItemStack dyespria) {
        CompoundTag tag = dyespria.m_41784_();
        int count = tag.m_128451_("amount");
        DyeColor color = DyeColor.m_41053_((int)tag.m_128451_("color"));
        return new Dye(color, count);
    }

    public static ItemStack stackFromDye(Dye dye) {
        return dye.isEmpty() ? ItemStack.f_41583_ : new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)dye.color), dye.amount);
    }

    public ItemStack toStack() {
        return new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)this.color), this.amount);
    }

    public static boolean dyeCheck(Dye dye, ItemStack dyeToInsert) {
        DyeItem dyeToInsertItem = (DyeItem)dyeToInsert.m_41720_();
        return dye.color.equals((Object)dyeToInsertItem.m_41089_());
    }

    public static int colorForDye(Colorable colorable, DyeColor dyeColor) {
        return colorable.colorValues().getOrDefault(dyeColor, -1);
    }

    public static void setDyeToDyeHolderStack(ItemStack dyespria, ItemStack dyeToInsert, int amount) {
        Dye.setDyeToDyeHolderStack(dyespria, dyeToInsert, amount, DyespriaItem.getDyespriaUses(dyespria));
    }

    public static void setDyeToDyeHolderStack(ItemStack dyespria, ItemStack dyeToInsert, int amount, int uses) {
        DyeColor dyeColor = dyeToInsert.m_41720_() instanceof DyeItem ? ((DyeItem)dyeToInsert.m_41720_()).m_41089_() : DyeColor.WHITE;
        CompoundTag tag = dyespria.m_41784_();
        tag.m_128405_("amount", amount);
        tag.m_128405_("color", dyeColor.m_41060_());
        tag.m_128405_("uses", uses);
        dyespria.m_41751_(tag);
    }

    public static void setDyeColorToStack(ItemStack stack, DyeColor color, int amount) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("amount", amount);
        tag.m_128405_("color", color.m_41060_());
        stack.m_41751_(tag);
    }

    public static DyeColor colorFromId(int id) {
        return DyeColor.m_41053_((int)id);
    }

    public int colorId() {
        return this.color.m_41060_();
    }
}

