/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.components;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public enum PatternspriaMode implements StringRepresentable
{
    SINGLE("single", DyespriaSelector::single, ChatFormatting.WHITE),
    COLUMN("column", DyespriaSelector::column, ChatFormatting.BLUE),
    ROW("row", DyespriaSelector::row, ChatFormatting.GREEN),
    SHAPE("shape", DyespriaSelector::shape, ChatFormatting.RED);

    public static final Codec<PatternspriaMode> CODEC;
    public static final IntFunction<PatternspriaMode> BY_ID;
    private final String name;
    private final Function<DyespriaSelector, Set<BlockPos>> selector;
    private final ChatFormatting textColor;

    private PatternspriaMode(String name, Function<DyespriaSelector, Set<BlockPos>> selector, ChatFormatting textColor) {
        this.name = name;
        this.selector = selector;
        this.textColor = textColor;
    }

    public static PatternspriaMode byIndex(int index) {
        return BY_ID.apply(index);
    }

    public static PatternspriaMode shift(PatternspriaMode current, int amount) {
        int size = PatternspriaMode.values().length;
        int currentIndex = current.ordinal();
        int newIndex = (currentIndex + amount) % size;
        return PatternspriaMode.byIndex(newIndex);
    }

    public String m_7912_() {
        return this.name;
    }

    public Function<DyespriaSelector, Set<BlockPos>> getSelector() {
        return this.selector;
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }

    static {
        CODEC = StringRepresentable.m_216439_(PatternspriaMode::values);
        BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])PatternspriaMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
    }

    public record DyespriaSelector(BlockPos originalPos, Level level, Direction clickedDir) {
        public Set<BlockPos> single() {
            return Set.of(this.originalPos());
        }

        public Set<BlockPos> column() {
            HashSet<BlockPos> ret = new HashSet<BlockPos>();
            ret.add(this.originalPos);
            BlockPos.MutableBlockPos posUp = this.originalPos.m_7494_().m_122032_();
            BlockPos.MutableBlockPos posDown = this.originalPos.m_7495_().m_122032_();
            while (this.matchBlock((BlockPos)posUp) && ret.size() <= 64) {
                ret.add(posUp.m_7949_());
                posUp.m_122173_(Direction.UP);
            }
            while (this.matchBlock((BlockPos)posDown) && ret.size() <= 64) {
                ret.add(posDown.m_7949_());
                posDown.m_122173_(Direction.DOWN);
            }
            return ret;
        }

        public Set<BlockPos> row() {
            HashSet<BlockPos> ret = new HashSet<BlockPos>();
            ret.add(this.originalPos);
            if (this.clickedDir == Direction.DOWN || this.clickedDir == Direction.UP) {
                return ret;
            }
            Direction rightDir = this.clickedDir.m_122428_();
            Direction leftDir = this.clickedDir.m_122427_();
            BlockPos.MutableBlockPos posRight = this.originalPos.m_121945_(rightDir).m_122032_();
            BlockPos.MutableBlockPos posDown = this.originalPos.m_121945_(leftDir).m_122032_();
            while (this.matchBlock((BlockPos)posRight) && ret.size() <= 64) {
                ret.add(posRight.m_7949_());
                posRight.m_122173_(rightDir);
            }
            while (this.matchBlock((BlockPos)posDown) && ret.size() <= 64) {
                ret.add(posDown.m_7949_());
                posDown.m_122173_(leftDir);
            }
            return ret;
        }

        public Set<BlockPos> shape() {
            return BlockPos.m_121985_((BlockPos)this.originalPos, (int)4, (int)4, (int)4).map(BlockPos::m_7949_).filter(this::matchBlock).collect(Collectors.toSet());
        }

        private boolean matchBlock(BlockPos pos) {
            BlockState state = this.level.m_8055_(pos);
            if (state.m_247087_()) {
                return false;
            }
            if (BlockPatternCapability.hasPattern(pos, this.level) && BlockPatternCapability.hasPattern(this.originalPos, this.level)) {
                int thisId;
                int originalId = BlockPatternCapability.getPattern(this.originalPos, this.level).patternId();
                return originalId == (thisId = BlockPatternCapability.getPattern(pos, this.level).patternId());
            }
            boolean isThisVisible = false;
            boolean isThisSturdy = false;
            for (Direction dir : Direction.values()) {
                if (!state.m_60783_((BlockGetter)this.level, pos, dir)) continue;
                isThisSturdy = true;
                break;
            }
            for (Direction dir : Direction.values()) {
                if (this.level.m_8055_(pos.m_121945_(dir)).m_60804_((BlockGetter)this.level, pos.m_121945_(dir))) continue;
                isThisVisible = true;
                break;
            }
            return isThisVisible && isThisSturdy;
        }
    }
}

