/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.data.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.abraxator.moresnifferflowers.init.ModRecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CropressingRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private Ingredient ingredient;
    private int count;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    public CropressingRecipeBuilder(ItemLike result) {
        this.result = result.m_5456_();
    }

    public RecipeBuilder requiresCrop(Item crop) {
        this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)crop)});
        this.count = 16;
        return this;
    }

    public RecipeBuilder requires(Ingredient item) {
        this.ingredient = item;
        return this;
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.result, this.ingredient, this.count, this.advancement, pRecipeId.m_246208_("recipes/cropressing/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public record Result(ResourceLocation id, Item result, Ingredient ingredient, int count, Advancement.Builder advancement, ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.ingredient.m_43942_());
            pJson.addProperty("count", (Number)this.count);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            pJson.add("result", (JsonElement)jsonObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.CROPRESSING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

