/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.effects;

import java.util.ArrayList;
import java.util.Comparator;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SaltyEffect
extends MobEffect {
    public SaltyEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.m_9236_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            double reach = player.getEntityReach();
            LivingEntity entity = (LivingEntity)SaltyEffect.getClosestEntity(level, (LivingEntity)player, reach);
            if (entity == null) return;
            player.m_5706_((Entity)entity);
            entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SALTY.get(), livingEntity.m_21124_((MobEffect)this).m_19557_() / 2, amplifier));
            return;
        }
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            if (livingEntity instanceof Enemy || livingEntity instanceof NeutralMob) {
                double reach = 1.5;
                LivingEntity entity = (LivingEntity)SaltyEffect.getClosestEntity(level, (LivingEntity)mob, reach);
                if (entity == null) return;
                if (!mob.m_21574_().m_148306_((Entity)entity)) return;
                mob.m_7327_((Entity)entity);
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SALTY.get(), (int)((double)livingEntity.m_21124_((MobEffect)this).m_19557_() / 1.5), amplifier));
                return;
            }
        }
        livingEntity.m_21195_((MobEffect)this);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % (1200 / (amplifier + 1)) == 0;
    }

    @Nullable
    public static Entity getClosestEntity(Level level, LivingEntity mid, double range) {
        Vec3 start = new Vec3(mid.m_146892_().f_82479_ - range, mid.m_146892_().f_82480_ - range, mid.m_146892_().f_82481_ - range);
        Vec3 end = new Vec3(mid.m_146892_().f_82479_ + range, mid.m_146892_().f_82480_ + range, mid.m_146892_().f_82481_ + range);
        ArrayList<Entity> list = new ArrayList<Entity>(level.m_45933_((Entity)mid, new AABB(start, end)).stream().filter(entity -> entity instanceof LivingEntity && ((LivingEntity)entity).m_142066_()).toList());
        if (list.isEmpty()) {
            return null;
        }
        list.sort(Comparator.comparing(entity -> {
            Vec3 pos1 = mid.m_20182_();
            Vec3 pos2 = entity.m_20182_();
            return pos1.m_82554_(pos2);
        }));
        return (Entity)list.get(0);
    }
}

