/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities.boat;

import net.abraxator.moresnifferflowers.blocks.ColorableVivicusBlock;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.entities.boat.ModBoatEntity;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VivicusBoatEntity
extends ModBoatEntity
implements ColorableVivicusBlock {
    private static final EntityDataAccessor<Integer> COLOR_DATA = SynchedEntityData.m_135353_(VivicusBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public VivicusBoatEntity(EntityType<? extends ModBoatEntity> entityType, Level level) {
        super(entityType, level);
    }

    public VivicusBoatEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends ModBoatEntity>)((EntityType)ModEntityTypes.MOD_VIVICUS_BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR_DATA, (Object)DyeColor.WHITE.m_41060_());
    }

    public void setColor(DyeColor color) {
        this.f_19804_.m_135381_(COLOR_DATA, (Object)color.m_41060_());
    }

    public DyeColor getColor() {
        return Dye.colorFromId((Integer)this.f_19804_.m_135370_(COLOR_DATA));
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack dyespria = player.m_21205_();
        if (dyespria.m_150930_((Item)ModItems.DYESPRIA.get())) {
            int dyeCount;
            Dye dye = Dye.getDyeFromDyespria(dyespria);
            int uses = DyespriaItem.getDyespriaUses(dyespria);
            if (uses <= 0) {
                dyeCount = dye.amount() - 1;
                DyespriaItem.setDyespriaUses(dyespria, 4);
            } else {
                dyeCount = dye.amount();
                DyespriaItem.setDyespriaUses(dyespria, uses);
            }
            this.setColor(dye.color());
            ItemStack stack = Dye.stackFromDye(new Dye(dye.color(), dyeCount));
            Dye.setDyeToDyeHolderStack(dyespria, stack, stack.m_41613_());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModAdvancementCritters.DYE_BOAT.m_222618_(serverPlayer);
            }
            if (this.m_9236_().f_46443_) {
                this.particles(this.f_19796_, this.m_9236_(), dye, BlockPos.m_274446_((Position)this.m_20182_()));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6096_(player, hand);
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Color", this.getColor().m_41060_());
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setColor(Dye.colorFromId(tag.m_128451_("Color")));
    }
}

