/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.events;

import java.util.HashSet;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="moresnifferflowers", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEvents {
    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        oldPlayer.reviveCaps();
        oldPlayer.getCapability(CapabilityList.UNLOCKED_NUTRITIONS).ifPresent(oldCap -> newPlayer.getCapability(CapabilityList.UNLOCKED_NUTRITIONS).ifPresent(newCap -> {
            newCap.setItems(new HashSet<Item>(oldCap.getItems()));
            newCap.sync(newPlayer);
        }));
        oldPlayer.getCapability(CapabilityList.MOUTH_SLOTS).ifPresent(oldCap -> newPlayer.getCapability(CapabilityList.MOUTH_SLOTS).ifPresent(newCap -> {
            newCap.setAllItems(oldCap.getMouthSlotItems());
            newCap.sync(newPlayer);
        }));
        oldPlayer.invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        event.getEntity().getCapability(CapabilityList.UNLOCKED_NUTRITIONS).ifPresent(cap -> {
            CompoundTag tag = event.getEntity().getPersistentData().m_128469_("NutritionData");
            cap.deserializeNBT(tag);
        });
        event.getEntity().getCapability(CapabilityList.MOUTH_SLOTS).ifPresent(cap -> {
            CompoundTag tag = event.getEntity().getPersistentData().m_128469_("MouthData");
            cap.deserializeNBT((Tag)tag);
        });
    }

    @SubscribeEvent
    public static void onPlayerSave(PlayerEvent.SaveToFile event) {
        event.getEntity().getCapability(CapabilityList.UNLOCKED_NUTRITIONS).ifPresent(cap -> {
            CompoundTag tag = cap.serializeNBT();
            event.getEntity().getPersistentData().m_128365_("NutritionData", (Tag)tag);
        });
        event.getEntity().getCapability(CapabilityList.MOUTH_SLOTS).ifPresent(cap -> {
            CompoundTag tag = (CompoundTag)cap.serializeNBT();
            event.getEntity().getPersistentData().m_128365_("MouthData", (Tag)tag);
        });
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        player.getCapability(CapabilityList.UNLOCKED_NUTRITIONS).ifPresent(cap -> cap.sync(player));
        player.getCapability(CapabilityList.MOUTH_SLOTS).ifPresent(cap -> cap.sync(player));
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        ServerPlayer player = event.getPlayer();
        if (!event.getLevel().f_46443_) {
            LevelChunk chunk = event.getChunk();
            chunk.getCapability(CapabilityList.BLOCK_PATTERNS).ifPresent(blockPatternCapability -> blockPatternCapability.sync(chunk.m_7697_()));
        }
    }
}

