/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.events;

import java.util.Objects;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.capability.GluedCapability;
import net.abraxator.moresnifferflowers.capability.UntouchableCapability;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.items.JarOfBonmeelItem;
import net.abraxator.moresnifferflowers.nutrition.NutritionLoader;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="moresnifferflowers", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new NutritionLoader());
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        MobEffect effect = event.getEffectInstance().m_19544_();
        LivingEntity entity = event.getEntity();
        if (effect.equals(ModEffects.GLUED.get())) {
            GluedCapability.setAndSync(entity, true, true);
        }
    }

    @SubscribeEvent
    public static void onEffectRemove(MobEffectEvent.Remove event) {
        MobEffectInstance effect = event.getEffectInstance();
        LivingEntity entity = event.getEntity();
        if (effect == null) {
            return;
        }
        ForgeEvents.onEffectEnd(effect.m_19544_(), entity);
    }

    @SubscribeEvent
    public static void onEffectExpire(MobEffectEvent.Expired event) {
        MobEffectInstance effect = event.getEffectInstance();
        LivingEntity entity = event.getEntity();
        if (effect == null) {
            return;
        }
        ForgeEvents.onEffectEnd(effect.m_19544_(), entity);
    }

    public static void onEffectEnd(MobEffect effect, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (effect.equals(ModEffects.HARDENED_MOUTH.get())) {
                player.getCapability(CapabilityList.MOUTH_SLOTS).ifPresent(cap -> cap.onEffectEnd(player));
            }
            if (effect.equals(ModEffects.SLIPPERY.get())) {
                player.getCapability(CapabilityList.SLIPPERY).ifPresent(cap -> cap.onEffectEnd(player));
            }
            if (effect.equals(ModEffects.COMBO_MEAL.get())) {
                player.getCapability(CapabilityList.COMBO_MEAL).ifPresent(cap -> cap.onEffectEnd(player));
            }
            if (effect.equals(ModEffects.UNTOUCHABLE.get())) {
                player.getCapability(CapabilityList.UNTOUCHABLE).ifPresent(cap -> cap.onEffectEnd(player));
            }
        }
        if (effect.equals(ModEffects.GLUED.get())) {
            GluedCapability.setAndSync(entity, false, true);
        }
    }

    @SubscribeEvent
    public static void itemEntity(ItemEvent event) {
        ItemEntity itemEntity = event.getEntity();
        ItemStack item = itemEntity.m_32055_();
        if (item.m_150930_((Item)ModItems.BURNED_SLOT.get())) {
            itemEntity.m_146870_();
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        boolean isCharged = player.m_36403_(0.5f) > 0.9f;
        Entity entity = event.getTarget();
        Level level = player.m_9236_();
        if (player.m_21023_((MobEffect)ModEffects.COMBO_MEAL.get()) && stack.m_204117_(ItemTags.f_271540_)) {
            player.getCapability(CapabilityList.COMBO_MEAL).ifPresent(cap -> cap.onAttack(player, isCharged));
        }
        if (player.m_21023_((MobEffect)ModEffects.GLUING_TOUCH.get()) && isCharged && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!level.f_46443_) {
                int amplifier = Objects.requireNonNull(player.m_21124_((MobEffect)ModEffects.GLUING_TOUCH.get())).m_19564_();
                if (level.f_46441_.m_188501_() < (float)(amplifier + 2) / 12.0f) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.GLUED.get(), (5 + amplifier * 2) * 20, 0));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAttacked(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21023_((MobEffect)ModEffects.UNTOUCHABLE.get())) {
            player.getCapability(CapabilityList.UNTOUCHABLE).ifPresent(UntouchableCapability::onAttacked);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        ItemEntity itemEntity = event.getItem();
        if (player.m_21023_((MobEffect)ModEffects.STICKY.get())) {
            if (!player.m_6047_()) {
                event.setCanceled(true);
            } else {
                int amplifier = player.m_21124_((MobEffect)ModEffects.STICKY.get()).m_19564_();
                int slowdown = 5 + amplifier * 2;
                if (event.getEntity().m_9236_().m_46467_() % (long)slowdown != 0L) {
                    event.setCanceled(true);
                    return;
                }
                ItemStack stack = itemEntity.m_32055_();
                ItemStack retStack = stack.m_41620_(1);
                player.m_36356_(retStack);
                itemEntity.m_32045_(stack);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Vec3 loc;
        BlockPos blockPos;
        LivingEntity livingEntity = event.getEntity();
        Level level = livingEntity.m_9236_();
        if (level.m_8055_(blockPos = BlockPos.m_274446_((Position)(loc = livingEntity.m_20182_()))).m_60713_((Block)ModBlocks.CORRUPTED_SLIME_LAYER.get()) || level.m_8055_(blockPos.m_7495_()).m_60713_((Block)ModBlocks.CORRUPTED_SLIME_LAYER.get())) {
            livingEntity.m_20256_(livingEntity.m_20184_().m_82542_(1.0, 0.3, 1.0));
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        BlockState state = event.getPlacedBlock();
        LevelAccessor badLevel = event.getLevel();
        if (state.m_204336_(ModTags.ModBlockTags.CORRUPTION_SHIELDING) && badLevel instanceof Level) {
            Level level = (Level)badLevel;
            LevelChunk chunk = level.m_46745_(event.getPos());
            chunk.getCapability(CapabilityList.CORRUPTION).ifPresent(cap -> {
                ++cap.resistance;
                cap.isSource = false;
                cap.flowers.add(event.getPos());
            });
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack output = event.getCrafting();
        Container input = event.getInventory();
        if (output.m_204117_(ModTags.ModItemTags.COLORABLE)) {
            for (int i = 0; i < input.m_6643_(); ++i) {
                ItemStack stack = input.m_8020_(i);
                int colorId = stack.m_41784_().m_128451_("MSF_ID");
                int color = stack.m_41784_().m_128451_("MSF_Hex");
                if (colorId == 0 || color == 0) continue;
                output.m_41784_().m_128405_("MSF_ID", colorId);
                output.m_41784_().m_128405_("MSF_Hex", color);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractRightClickItem(PlayerInteractEvent.RightClickBlock event) {
        BlockPatternCapability.PatternData data;
        BlockState state1;
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack itemStack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        ItemStack item = player.m_21120_(hand).m_41720_().m_7968_();
        if (event.isCanceled()) {
            return;
        }
        Item item2 = item.m_41720_();
        if (item2 instanceof JarOfBonmeelItem) {
            JarOfBonmeelItem jar = (JarOfBonmeelItem)item2;
            if (state.m_204336_(ModTags.ModBlockTags.BONMEELABLE)) {
                event.setCanceled(true);
                event.setCancellationResult(jar.m_6225_(new UseOnContext(player, hand, event.getHitVec())));
            }
        }
        if ((item.m_150930_((Item)ModItems.REBREWED_POTION.get()) || item.m_150930_((Item)ModItems.EXTRACTED_BOTTLE.get())) && state.m_60713_(Blocks.f_50493_)) {
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
        }
        if (item.m_204117_(ItemTags.f_271207_) && (state.m_60713_((Block)ModBlocks.VIVICUS_LOG.get()) || state.m_60713_((Block)ModBlocks.VIVICUS_WOOD.get()))) {
            Block strippedBlock = (Block)AxeItem.f_150683_.get(state.m_60734_());
            state1 = (BlockState)((BlockState)strippedBlock.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)))).m_61124_(ModStateProperties.COLOR, (Comparable)((DyeColor)state.m_61143_(ModStateProperties.COLOR)));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, item);
            }
            level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, state1, 3);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state1));
            itemStack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(player1.m_7655_()));
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if ((item.m_150930_((Item)ModItems.JAR_OF_BONMEEL.get()) || item.m_150930_((Item)ModItems.JAR_OF_ACID.get())) && state.m_60713_(Blocks.f_50256_)) {
            Block cauldronType = item.m_150930_((Item)ModItems.JAR_OF_BONMEEL.get()) ? (Block)ModBlocks.BONMEEL_FILLED_CAULDRON.get() : (Block)ModBlocks.ACID_FILLED_CAULDRON.get();
            state1 = (BlockState)cauldronType.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
            level.m_7731_(pos, state1, 3);
            level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, pos);
            if (!player.m_7500_()) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (BlockPatternCapability.hasPattern(pos, level) && itemStack.m_150930_(Items.f_151056_) && !(data = BlockPatternCapability.getPattern(pos, level)).isGlowing()) {
            BlockPatternCapability.enableGlowing(level, pos);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (itemStack.m_150930_(Items.f_42409_) && state.m_60713_(Blocks.f_271329_)) {
            itemStack.m_41622_(1, (LivingEntity)player, player1 -> {});
            player.m_21008_(hand, itemStack);
            level.m_7731_(pos, (BlockState)((Block)ModBlocks.TORCHFLOWER_AFLAME.get()).m_49966_().m_61124_((Property)ModStateProperties.AGE_2, (Comparable)Integer.valueOf(1)), 3);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

