/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.ArrayList;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.capability.NutritionCapability;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.nutrition.NutritionType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class RootedSoupItem
extends Item {
    public RootedSoupItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.m_21120_(usedHand);
        player.m_6672_(usedHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        int uses;
        Player player = (Player)livingEntity;
        FoodData foodData = player.m_36324_();
        CompoundTag tag = stack.m_41784_();
        int food = tag.m_128451_("soupFood");
        int sat = tag.m_128451_("soupSat");
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        ListTag effectsTag = tag.m_128437_("effects", 10);
        for (Tag tag1 : effectsTag) {
            CompoundTag effectTag = (CompoundTag)tag1;
            int id = effectTag.m_128451_("nutritionType");
            int dur = effectTag.m_128451_("dur");
            int amp = effectTag.m_128451_("amp");
            boolean positive = effectTag.m_128471_("positive");
            player.getCapability(CapabilityList.UNLOCKED_NUTRITIONS).ifPresent(cap -> cap.unlockedEffects.add(NutritionCapability.idFromNutrition(NutritionType.byId(id), positive)));
            MobEffect mobEffect = NutritionType.getEffect(NutritionType.byId(id), positive);
            if (mobEffect == null) continue;
            effects.add(new MobEffectInstance(mobEffect, dur, amp));
        }
        foodData.m_38707_(food, (float)sat);
        if (!level.f_46443_) {
            for (MobEffectInstance effect : effects) {
                player.m_7292_(effect);
            }
        }
        if ((uses = tag.m_128451_("soupCount") - 1) <= 0) {
            return Items.f_42399_.m_7968_();
        }
        ListTag ingredientListTag = tag.m_128437_("ingredients", 10);
        for (Tag ingredientTag : ingredientListTag) {
            ItemStack ingredient = ItemStack.m_41712_((CompoundTag)((CompoundTag)ingredientTag));
            player.getCapability(CapabilityList.UNLOCKED_NUTRITIONS).ifPresent(nutritionCapability -> nutritionCapability.addItem(ingredient.m_41720_()));
        }
        tag.m_128405_("soupCount", uses);
        stack.m_41751_(tag);
        return stack;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41784_().m_128451_("soupCount") > 0;
    }

    public int m_142159_(ItemStack stack) {
        int input = stack.m_41784_().m_128451_("soupCount");
        int maxInput = stack.m_41784_().m_128441_("soupCountMax") ? stack.m_41784_().m_128451_("soupCountMax") : 4;
        return ModColorHandler.barColorHelper(input, maxInput);
    }

    public int m_142158_(ItemStack stack) {
        int max = stack.m_41784_().m_128441_("soupCountMax") ? stack.m_41784_().m_128451_("soupCountMax") : 4;
        return Math.round((float)stack.m_41784_().m_128451_("soupCount") / (float)max * 13.0f);
    }
}

