/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.networking.toClient;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record SyncNutritionPacket(Set<Item> nutritionItems, Set<Integer> effects) {
    public static void encode(SyncNutritionPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.nutritionItems.size());
        for (Item item : msg.nutritionItems) {
            buffer.m_130085_(BuiltInRegistries.f_257033_.m_7981_((Object)item));
        }
        buffer.writeInt(msg.effects.size());
        for (Integer effect : msg.effects) {
            buffer.writeInt(effect.intValue());
        }
    }

    public static SyncNutritionPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashSet<Item> nutritionItems = new HashSet<Item>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation itemId = buffer.m_130281_();
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
            if (item == Items.f_41852_) continue;
            nutritionItems.add(item);
        }
        int effectSize = buffer.readInt();
        HashSet<Integer> effects = new HashSet<Integer>();
        for (int i = 0; i < effectSize; ++i) {
            effects.add(buffer.readInt());
        }
        return new SyncNutritionPacket(nutritionItems, effects);
    }

    public static void handle(SyncNutritionPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> SyncNutritionPacket.handlePacket(msg, context));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(SyncNutritionPacket msg, NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(CapabilityList.UNLOCKED_NUTRITIONS).ifPresent(cap -> {
                cap.setItems(msg.nutritionItems);
                cap.unlockedEffects = msg.effects;
            });
        }
    }
}

