/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.nutrition;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.abraxator.moresnifferflowers.nutrition.NutritionEntry;
import net.abraxator.moresnifferflowers.nutrition.NutritionLoader;
import net.abraxator.moresnifferflowers.nutrition.NutritionType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class Nutrition {
    private final Item item;
    private final List<NutritionEntry> nutritionEntries;
    private int saturation;
    public static final Nutrition EMPTY = new Nutrition(Items.f_41852_, List.of());

    public Nutrition(Item item, List<NutritionEntry> nutritionEntries) {
        this.item = item;
        this.nutritionEntries = nutritionEntries;
    }

    public Item getItem() {
        return this.item;
    }

    public List<NutritionEntry> getNutritionEntries() {
        return this.nutritionEntries;
    }

    public static Nutrition getNutritionForItem(Item item) {
        Set<Nutrition> nutritions = NutritionLoader.modNutritions.get(BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135827_());
        if (nutritions != null) {
            for (Nutrition nutrition : nutritions) {
                if (nutrition.getItem() != item) continue;
                return nutrition;
            }
        }
        return EMPTY;
    }

    public static NutritionType getLargestNutrition(Item item) {
        Nutrition nutrition = Nutrition.getNutritionForItem(item);
        ArrayList<NutritionEntry> list = new ArrayList<NutritionEntry>(nutrition.nutritionEntries);
        if (list.isEmpty()) {
            return NutritionType.NEUTRAL;
        }
        list.sort(Comparator.comparing(nutritionEntry -> Float.valueOf(-((float)nutritionEntry.weight() + nutritionEntry.nutrition().priority))));
        return ((NutritionEntry)list.get(0)).nutrition();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }
}

