/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.recipes;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModRecipeSerializers;
import net.abraxator.moresnifferflowers.init.ModRecipeTypes;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public record CorruptionRecipe(ResourceLocation id, String source, List<Entry> list) implements Recipe<Container>
{
    public static final Map<Block, Block> HARDCODED_BLOCK = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put((Block)ModBlocks.DYESPRIA_PLANT.get(), (Block)ModBlocks.DYESCRAPIA_PLANT.get());
        map.put((Block)ModBlocks.DAWNBERRY_VINE.get(), (Block)ModBlocks.GLOOMBERRY_VINE.get());
        map.put((Block)ModBlocks.BONMEELIA.get(), (Block)ModBlocks.BONWILTIA.get());
        map.put((Block)ModBlocks.BONDRIPIA.get(), (Block)ModBlocks.ACIDRIPIA.get());
        map.put((Block)ModBlocks.AMBUSH_BOTTOM.get(), (Block)ModBlocks.GARBUSH_BOTTOM.get());
        map.put((Block)ModBlocks.AMBUSH_TOP.get(), (Block)ModBlocks.GARBUSH_TOP.get());
        map.put((Block)ModBlocks.SALTEMONE.get(), (Block)ModBlocks.SOURLEMONE.get());
        map.put((Block)ModBlocks.CAULORFLOWER.get(), (Block)ModBlocks.PATTERNFLOWER.get());
        map.put((Block)ModBlocks.TORCHFLOWER_AFLAME.get(), (Block)ModBlocks.TORCHEWFLOWER.get());
        map.put(Blocks.f_271329_, (Block)ModBlocks.TORCHEWFLOWER.get());
    });

    public boolean tagOrBlock() {
        return this.source.charAt(0) == '#';
    }

    public Optional<TagKey<Block>> inputTag() {
        return Optional.of(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.m_135820_((String)this.source.replace("#", ""))));
    }

    public Optional<Block> inputBlock() {
        return Optional.of((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)this.source)));
    }

    public boolean m_5818_(Container container, Level level) {
        BlockState block = Block.m_49814_((Item)container.m_8020_(0).m_41720_()).m_49966_();
        if (this.tagOrBlock()) {
            return block.m_204336_(this.inputTag().get());
        }
        if (ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)this.source)) != null) {
            return block.m_60713_(this.inputBlock().get());
        }
        throw new ResourceLocationException(ResourceLocation.m_135820_((String)this.source) + "must be a block or block tag");
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public static Optional<Block> getCorruptedBlock(Block block, Level level) {
        Block hardcoded = HARDCODED_BLOCK.getOrDefault(block, Blocks.f_50016_);
        if (hardcoded != Blocks.f_50016_) {
            return Optional.of(hardcoded);
        }
        Optional optionalRecipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CORRUPTION.get(), (Container)new SimpleContainer(new ItemStack[]{block.m_5456_().m_7968_()}), level);
        return optionalRecipe.map(corruptionRecipe -> corruptionRecipe.getResultBlock(level.f_46441_));
    }

    public static boolean canBeCorrupted(Block block, Level level) {
        if (block == null || block.m_49966_().m_204336_(ModTags.ModBlockTags.UNCORRUPTABLE)) {
            return false;
        }
        return CorruptionRecipe.getCorruptedBlock(block, level).isPresent();
    }

    public Block getResultBlock(RandomSource randomSource) {
        int totalWeight = this.list.stream().mapToInt(Entry::weight).sum();
        int cumulativeWeight = 0;
        if (randomSource != null) {
            int randomValue = randomSource.m_188503_(totalWeight);
            for (Entry entry : this.list) {
                if (randomValue >= (cumulativeWeight += entry.weight)) continue;
                return entry.block;
            }
        } else {
            Iterator<Entry> iterator = this.list.iterator();
            if (iterator.hasNext()) {
                Entry entry = iterator.next();
                return entry.block;
            }
        }
        return Blocks.f_50016_;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getResultBlock(null).m_5456_().m_7968_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CORRUPTION.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CORRUPTION.get();
    }

    public record Entry(Block block, int weight) {
        public static Entry fromJsonElement(JsonElement element) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)element.getAsJsonObject(), (String)"block")));
            int weight = GsonHelper.m_13927_((JsonObject)element.getAsJsonObject(), (String)"weight");
            return new Entry(block, weight);
        }
    }
}

