/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.abraxator.moresnifferflowers.blockentities.IModBlockEntity;
import net.abraxator.moresnifferflowers.blocks.BerootCauldronBlock;
import net.abraxator.moresnifferflowers.components.BetterNonNullList;
import net.abraxator.moresnifferflowers.components.RootedSoup;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.networking.toClient.BerootCauldronSuckPacket;
import net.abraxator.moresnifferflowers.networking.toServer.BerootCauldronCraftPacket;
import net.abraxator.moresnifferflowers.nutrition.Nutrition;
import net.abraxator.moresnifferflowers.nutrition.NutritionEntry;
import net.abraxator.moresnifferflowers.nutrition.NutritionType;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.nikdo53.tinymultiblocklib.blockentities.AbstractMultiBlockEntity;
import org.jetbrains.annotations.Nullable;

public class BerootCauldronBlockEntity
extends AbstractMultiBlockEntity
implements IModBlockEntity {
    public int beetroots = 0;
    private final int foodLimit = 8;
    public BetterNonNullList<ItemStack> ingredients = BetterNonNullList.withSize(8, ItemStack.EMPTY);
    public int itemRot = 0;
    public ItemStack soup = ItemStack.EMPTY;
    public int soupCount = 0;
    public boolean isCrafted = false;
    public final int MAX_SOUP_COUNT = 6;
    private final int beetrootLimit = 4;
    private final int spoonSpeed = 10;
    int spoonRotation = 0;
    public boolean redSoup = true;
    boolean crafting = false;
    int craftingTimeRemaining = 0;

    public BerootCauldronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BEROOT_CAULDRON.get(), pos, state);
    }

    public ItemInteractionResult addItem(ItemStack itemStack, Player player) {
        if (itemStack.is((Item)ModItems.CROPRESSED_BEETROOT.get()) && this.beetroots < 4 && !this.isCrafted) {
            this.addBeetroot(itemStack, player);
            this.redSoup = true;
        } else if (!(itemStack.isEmpty() || this.ingredients.isFull() || Nutrition.getNutritionForItem(itemStack.getItem()).isEmpty() || this.isCrafted || this.beetroots <= 0)) {
            this.addIngredient(itemStack, player);
            this.redSoup = false;
        } else {
            if (itemStack.is(Items.BOWL) && this.isCrafted) {
                return this.giveSoup(itemStack, player);
            }
            if (!this.ingredients.isFullyDefault() && !this.isCrafted && player != null) {
                this.crafting = true;
            } else {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void craft() {
        if (this.ingredients.isFullyDefault()) {
            return;
        }
        this.isCrafted = true;
        HashMap map = new HashMap();
        ItemStack soup = ((Item)ModItems.ROOTED_SOUP.get()).getDefaultInstance();
        CompoundTag tag = new CompoundTag();
        int neutral = 0;
        this.ingredients.validStream().forEach(stack -> {
            Nutrition nutrition = Nutrition.getNutritionForItem(stack.getItem());
            nutrition.getNutritionEntries().forEach(entry -> map.merge(entry.nutrition(), entry.weight(), Integer::sum));
        });
        ArrayList<NutritionEntry> entryList = new ArrayList<NutritionEntry>(map.entrySet().stream().map(entry -> new NutritionEntry((NutritionType)((Object)((Object)entry.getKey())), (Integer)entry.getValue())).sorted(Comparator.comparing(NutritionEntry::weight)).toList());
        int sat = this.ingredients.validStream().filter(itemStack -> itemStack.getFoodProperties(null) != null).mapToInt(value -> (int)value.getFoodProperties(null).saturation()).sum();
        int food = this.ingredients.validStream().filter(itemStack -> itemStack.getFoodProperties(null) != null).mapToInt(value -> value.getFoodProperties(null).nutrition()).sum();
        int ingredients = this.ingredients.getValidSize();
        this.soupCount = this.beetroots + ingredients / 4;
        int soupFood = 6 + food / ingredients;
        float soupSat = 7.0f + (float)sat / (float)ingredients;
        for (NutritionEntry nutritionEntry : entryList) {
            if (!nutritionEntry.nutrition().equals((Object)NutritionType.NEUTRAL)) continue;
            neutral += nutritionEntry.weight();
        }
        int maxSoupUses = 6;
        int soupUses = Math.min(Math.max(Math.round((float)food / 3.0f) + (ingredients - 4) / 2, 1), maxSoupUses);
        soup.set(ModDataComponents.ROOTED_INGREDIENTS, this.ingredients.validStream().toList());
        soup.set(ModDataComponents.ROOTED_SOUP, (Object)new RootedSoup(soupFood, soupSat, soupUses));
        soup.set(ModDataComponents.USES, (Object)soupUses);
        float positiveThreshold = 0.5f;
        float negativeThreshold = 0.75f;
        float perfectMix = (positiveThreshold + negativeThreshold) / 2.0f;
        int maxAmp = 4;
        float ampThresholds = (perfectMix - positiveThreshold) / (float)maxAmp;
        int minDuration = 1200;
        int duration = minDuration + neutral / 100 * 60 * 20;
        int totalFlavour = 0;
        int blandThreshold = 120;
        int minFlavour = 50;
        ArrayList<RootedSoup.RootedEffect> effects = new ArrayList<RootedSoup.RootedEffect>();
        for (NutritionEntry nutritionEntry : entryList) {
            if (nutritionEntry.nutrition().equals((Object)NutritionType.NEUTRAL)) continue;
            totalFlavour += nutritionEntry.weight();
            float ratio = (float)nutritionEntry.weight() / ((float)neutral + 1.0f);
            int amplifier = 1;
            Boolean positive = null;
            if (ratio > negativeThreshold) {
                amplifier = Math.round((ratio - negativeThreshold) / ampThresholds);
                positive = false;
                duration /= 2;
            } else if (ratio > positiveThreshold) {
                positive = true;
                amplifier = maxAmp;
                float inaccuracy = Mth.abs((float)(ratio - perfectMix));
                amplifier -= Math.round(inaccuracy / ampThresholds);
            }
            amplifier = Math.max(Math.min(amplifier, maxAmp), 1);
            if (positive == null || nutritionEntry.weight() < minFlavour) continue;
            effects.add(new RootedSoup.RootedEffect(nutritionEntry.nutrition().ordinal(), positive, duration, amplifier));
        }
        if (effects.isEmpty()) {
            boolean positive = totalFlavour > blandThreshold;
            int amplifier = totalFlavour < blandThreshold ? 1 : Math.min(Mth.floor((float)((float)(totalFlavour - blandThreshold) / 100.0f + 1.0f)), 3);
            effects.add(new RootedSoup.RootedEffect(NutritionType.NEUTRAL.ordinal(), positive, duration, amplifier));
        }
        soup.set(ModDataComponents.ROOTED_EFFECTS, effects);
        Vec3 color = this.color();
        soup.set(ModDataComponents.COLOR, (Object)FastColor.ARGB32.color((int)((int)color.x), (int)((int)color.y), (int)((int)color.z)));
        this.soup = soup;
        this.setChanged();
    }

    @Override
    public void tick(Level level) {
        if (this.isCenter()) {
            this.suckInItems(level, this.center);
        }
    }

    @Override
    public void clientTick(ClientLevel level) {
        if (!this.isCenter()) {
            return;
        }
        ++this.itemRot;
        if (this.crafting && this.craftingTimeRemaining < 9) {
            ++this.spoonRotation;
            ++this.craftingTimeRemaining;
            this.itemRot += 10;
            if (this.spoonRotation * 10 >= this.soupCount * 180 && this.soupCount != 0) {
                PacketDistributor.sendToServer((CustomPacketPayload)new BerootCauldronCraftPacket(this.center), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.craft();
                this.crafting = false;
                this.isCrafted = true;
                this.craftingTimeRemaining = 0;
                this.spoonRotation %= 36;
                Vec3 center = this.getMiddle();
                for (int i = 0; i < 360; ++i) {
                    if (i % 20 != 0) continue;
                    this.level.addParticle((ParticleOptions)ParticleTypes.LAVA, center.x, center.y, center.z, (double)Mth.cos((float)i), 0.5, (double)Mth.sin((float)i));
                }
            }
        } else {
            this.crafting = false;
            this.craftingTimeRemaining = 0;
        }
    }

    private boolean valuesClose(List<NutritionEntry> entryList, int tolerance) {
        List<Integer> weights = entryList.stream().map(NutritionEntry::weight).toList();
        int min = Collections.min(weights);
        int max = Collections.max(weights);
        return max - min <= tolerance;
    }

    public boolean hasSoup() {
        return this.soupCount > 0 && !this.soup.equals(ItemStack.EMPTY);
    }

    private ItemInteractionResult giveSoup(ItemStack itemStack, Player player) {
        boolean isServer;
        boolean b = !this.hasSoup();
        boolean b1 = !this.isCrafted;
        boolean bl = isServer = !this.level.isClientSide;
        if (b || b1) {
            return ItemInteractionResult.FAIL;
        }
        itemStack.shrink(1);
        ItemStack soup1 = this.soup.copy();
        player.setItemInHand(InteractionHand.MAIN_HAND, ItemUtils.createFilledResult((ItemStack)player.getItemInHand(InteractionHand.MAIN_HAND), (Player)player, (ItemStack)soup1, (boolean)false));
        --this.soupCount;
        if (this.soupCount <= 0) {
            this.soup = ItemStack.EMPTY;
            this.clearIngredients();
        }
        this.setChanged();
        return ItemInteractionResult.SUCCESS;
    }

    private void addIngredient(ItemStack itemStack, Player player) {
        this.ingredients.set(this.ingredients.getFirstEmptySlot(), new ItemStack((ItemLike)itemStack.getItem(), 1));
        int ingredients = this.ingredients.getValidSize();
        this.soupCount = this.beetroots + ingredients / 4;
        if (this.level.isClientSide) {
            Vec3 center = this.getMiddle();
            for (int i = 0; i < 360; ++i) {
                if (i % 20 != 0) continue;
                this.level.addParticle((ParticleOptions)new DustParticleOptions(this.color(itemStack.getItem()).scale(0.00392156862745098).toVector3f(), 1.0f), center.x, center.y, center.z, (double)Mth.cos((float)i), 0.5, (double)Mth.sin((float)i));
            }
        }
        itemStack.shrink(1);
        this.setChanged();
    }

    private void addBeetroot(ItemStack itemStack, Player player) {
        ++this.beetroots;
        int ingredients = this.ingredients.getValidSize();
        this.soupCount = this.beetroots + ingredients / 4;
        itemStack.shrink(1);
        if (!this.level.isClientSide) {
            return;
        }
        Vec3 center = this.getMiddle();
        for (int i = 0; i < 360; ++i) {
            if (i % 20 != 0) continue;
            this.level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)16007990).toVector3f(), 1.0f), center.x, center.y, center.z, (double)Mth.cos((float)i), 0.5, (double)Mth.sin((float)i));
        }
        this.setChanged();
    }

    public void suckInItems(Level level, BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        switch ((Direction)level.getBlockState(pos).getValue((Property)HorizontalDirectionalBlock.FACING)) {
            case EAST: {
                ++x;
                break;
            }
            case NORTH: {
                ++x;
                --z;
                break;
            }
            case WEST: {
                --z;
            }
        }
        for (ItemEntity itementity : BerootCauldronBlockEntity.getItemsAtAndAbove(level, new BlockPos(x, y, z))) {
            ItemStack itemStack = itementity.getItem().copy();
            ItemStack itemStack1 = itemStack.copy();
            if (!this.addItem(itemStack, null).equals((Object)ItemInteractionResult.SUCCESS)) continue;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BerootCauldronSuckPacket(itemStack1, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            itementity.setItem(itemStack);
        }
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level level, BlockPos pos) {
        return BerootCauldronBlock.SHAPE_INSIDE.toAabbs().stream().flatMap(p_155558_ -> level.getEntitiesOfClass(ItemEntity.class, p_155558_.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ() + 1.125), EntitySelector.ENTITY_STILL_ALIVE).stream()).collect(Collectors.toList());
    }

    public float getItemsRotation(float partialTick) {
        if (this.crafting) {
            partialTick *= 10.0f;
        }
        return ((float)this.itemRot + partialTick) * 2.0f;
    }

    public float getSpoonRotation(float partialTick) {
        if (this.crafting && this.spoonRotation % 9 != 0) {
            return ((float)this.spoonRotation + partialTick) * 10.0f;
        }
        return this.spoonRotation * 10;
    }

    private Vec3 getMiddle() {
        float x = -0.5f;
        float y = 1.5f;
        float z = 0.5f;
        switch ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)) {
            case EAST: {
                x += 1.0f;
                break;
            }
            case NORTH: {
                x += 1.0f;
                z -= 1.0f;
                break;
            }
            case WEST: {
                z -= 1.0f;
            }
        }
        return this.center.getCenter().add((double)x, (double)y, (double)z);
    }

    public void clearIngredients() {
        this.ingredients.clear();
        this.beetroots = 0;
        this.isCrafted = false;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.isCenter()) {
            return;
        }
        tag.putInt("beetroots", this.beetroots);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.ingredients, (HolderLookup.Provider)registries);
        tag.putInt("soupCount", this.soupCount);
        tag.putBoolean("crafting", this.crafting);
        tag.putInt("craftingTime", this.craftingTimeRemaining);
        tag.putBoolean("isCrafted", this.isCrafted);
        tag.putBoolean("redSoup", this.redSoup);
        tag.putInt("spoonRotation", this.spoonRotation);
        if (!this.soup.isEmpty()) {
            CompoundTag soupTag = new CompoundTag();
            this.soup.save(registries, (Tag)soupTag);
            tag.put("soup", (Tag)soupTag);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!this.isCenter()) {
            return;
        }
        this.ingredients.clear();
        this.beetroots = tag.getInt("beetroots");
        ContainerHelper.loadAllItems((CompoundTag)tag, this.ingredients, (HolderLookup.Provider)registries);
        this.soupCount = tag.getInt("soupCount");
        this.crafting = tag.getBoolean("crafting");
        this.craftingTimeRemaining = tag.getInt("craftingTime");
        this.isCrafted = tag.getBoolean("isCrafted");
        this.redSoup = tag.getBoolean("redSoup");
        this.spoonRotation = tag.getInt("spoonRotation");
        boolean soup1 = tag.contains("soup");
        if (soup1) {
            this.soup = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("soup"));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Vec3 color() {
        return this.color(Items.AIR);
    }

    public Vec3 color(Item item) {
        int loop;
        int r = 0;
        int g = 0;
        int b = 0;
        Item latestIngredient = Items.AIR;
        if (!this.ingredients.isFullyDefault()) {
            latestIngredient = this.ingredients.getLastValid().getItem();
        }
        if (!item.equals(Items.AIR)) {
            latestIngredient = item;
        }
        int n = loop = this.isCrafted ? this.ingredients.size() : 1;
        if (!latestIngredient.equals(Items.AIR)) {
            block7: for (int i = 0; i < loop; ++i) {
                if (this.isCrafted) {
                    latestIngredient = ((ItemStack)this.ingredients.get(i)).getItem();
                }
                if (latestIngredient.equals(Items.AIR)) continue;
                NutritionType nutritionType = Nutrition.getLargestNutrition(latestIngredient);
                switch (nutritionType) {
                    case SOUR: {
                        r += 255;
                        g += 205;
                        b += 0;
                        continue block7;
                    }
                    case SALTY: {
                        r += 190;
                        g += 233;
                        b += 233;
                        continue block7;
                    }
                    case SPICY: {
                        r += 187;
                        g += 67;
                        b += 48;
                        continue block7;
                    }
                    case SWEET: {
                        r += 230;
                        g += 120;
                        b += 150;
                        continue block7;
                    }
                    case NEUTRAL: {
                        r += 140;
                        g += 102;
                        b += 30;
                    }
                }
            }
        }
        if (this.isCrafted && !this.ingredients.isFullyDefault()) {
            r /= this.ingredients.getValidSize();
            g /= this.ingredients.getValidSize();
            b /= this.ingredients.getValidSize();
        }
        if (this.redSoup && item.equals(Items.AIR) && !this.isCrafted) {
            r = 164;
            g = 39;
            b = 44;
        }
        return new Vec3((double)r, (double)g, (double)b);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

