/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import java.util.Map;
import net.abraxator.moresnifferflowers.blockentities.ModBlockEntity;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ColoredBlockEntity
extends ModBlockEntity
implements Colorable {
    public Dye dye = Dye.EMPTY;

    public ColoredBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public Map<DyeColor, Integer> colorValues() {
        return null;
    }

    public Dye removeDye() {
        Dye ret = this.dye;
        this.dye = Dye.EMPTY;
        this.setChanged();
        return ret;
    }

    @Override
    public void onAddDye(@Nullable ItemStack destinationStack, ItemStack dyeStack, int amount) {
        this.dye = Dye.getDyeFromDyeStack(dyeStack);
        this.setChanged();
    }

    public void setChanged() {
        BlockState blockState = (BlockState)this.getBlockState().setValue(ModStateProperties.COLOR, (Comparable)this.dye.color());
        if (this.dye.isEmpty()) {
            blockState.setValue(ModStateProperties.COLOR, (Comparable)DyeColor.WHITE);
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        this.level.setBlockAndUpdate(this.getBlockPos(), blockState);
        super.setChanged();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.dye = Dye.EMPTY;
        this.dye = new Dye(DyeColor.byId((int)tag.getInt("dyeId")), tag.getInt("amount"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("dyeId", this.dye.color().getId());
        tag.putInt("amount", this.dye.amount());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        super.getUpdateTag(registries);
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

