/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import com.mojang.serialization.MapCodec;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;

public class BonmeeliaBlock
extends BushBlock
implements ModCropBlock {
    public static final MapCodec<BonmeeliaBlock> CODEC = BonmeeliaBlock.simpleCodec(properties -> new BonmeeliaBlock((BlockBehaviour.Properties)properties, false));
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)6);
    public static final BooleanProperty HAS_BOTTLE = BooleanProperty.create((String)"bottle");
    public static final BooleanProperty SHOW_HINT = BooleanProperty.create((String)"hint");
    public static final BooleanProperty HAS_JAR = BooleanProperty.create((String)"jar");
    public static final int MAX_AGE = AGE.getAllValues().map(Property.Value::value).max(Integer::compare).orElse(0);
    private final boolean wilted;

    public BonmeeliaBlock(BlockBehaviour.Properties properties, boolean wilted) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HAS_BOTTLE, (Comparable)Boolean.valueOf(false))).setValue((Property)SHOW_HINT, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)HAS_JAR, (Comparable)Boolean.valueOf(false)));
        this.wilted = wilted;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, HAS_BOTTLE, SHOW_HINT, HAS_JAR});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(level.getBlockState(pos.below()));
    }

    @Override
    public boolean mayPlaceOn(BlockState state) {
        return ModCropBlock.super.mayPlaceOn(state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.GLASS_BOTTLE) && this.canInsertBottle(state)) {
            return this.addBottle(level, pos, state, stack, player);
        }
        if (stack.is(Items.BONE_MEAL) && (Integer)state.getValue((Property)AGE) < 3) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)HAS_BOTTLE)).booleanValue() && (Integer)state.getValue((Property)AGE) >= MAX_AGE) {
            return this.takeJarOfBonmeel(level, pos, state);
        }
        if (!((Boolean)state.getValue((Property)HAS_BOTTLE)).booleanValue() && this.getAge(state) >= 3) {
            return this.hint(level, pos, state);
        }
        return InteractionResult.PASS;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, (BlockState)state.setValue((Property)SHOW_HINT, (Comparable)Boolean.valueOf(false)), 3);
    }

    private ItemInteractionResult addBottle(Level level, BlockPos blockPos, BlockState blockState, ItemStack stack, Player player) {
        if (!level.isClientSide) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)HAS_BOTTLE, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private InteractionResult takeJarOfBonmeel(Level level, BlockPos blockPos, BlockState blockState) {
        level.setBlock(blockPos, (BlockState)((BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(3))).setValue((Property)HAS_BOTTLE, (Comparable)Boolean.valueOf(false)), 3);
        BonmeeliaBlock.popResource((Level)level, (BlockPos)blockPos, (ItemStack)(this.wilted ? ModItems.JAR_OF_ACID.toStack() : ModItems.JAR_OF_BONMEEL.toStack()));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    private InteractionResult hint(Level level, BlockPos blockPos, BlockState blockState) {
        level.setBlock(blockPos, (BlockState)blockState.setValue((Property)SHOW_HINT, (Comparable)Boolean.valueOf(true)), 3);
        level.getBlockTicks().schedule(new ScheduledTick((Object)this, blockPos, level.getGameTime() + 40L, level.nextSubTickCount()));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.getAge(state) < 3 || this.getAge(state) >= 3 && (Boolean)state.getValue((Property)HAS_BOTTLE) != false;
    }

    private boolean canInsertBottle(BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) == 3 && (Boolean)blockState.getValue((Property)HAS_BOTTLE) == false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.isMaxAge(state)) {
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(this.getAge(state) + 1))).setValue((Property)HAS_JAR, (Comparable)Boolean.valueOf(this.getAge(state) + 1 == MAX_AGE && (Boolean)state.getValue((Property)HAS_BOTTLE) != false)));
            DustParticleOptions particle = new DustParticleOptions(this.wilted ? Vec3.fromRGB24((int)11468636).toVector3f() : Vec3.fromRGB24((int)11162034).toVector3f(), 1.0f);
            if (this.getAge(state) >= 3) {
                for (int i = 0; i <= random.nextIntBetweenInclusive(5, 10); ++i) {
                    level.sendParticles((ParticleOptions)particle, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 1, 0.0, 0.0, 0.0, 0.3);
                }
            }
        }
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return this.getAge(state) < 3;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.makeGrowOnBonemeal((Level)level, pos, state);
    }
}

