/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.Map;
import java.util.Optional;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.SimpleAdvancementTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CaulorflowerBlock
extends Block
implements BonemealableBlock,
ModCropBlock,
Colorable,
Corruptable {
    public CaulorflowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        if (!this.isCorrupted()) {
            this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ModStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(true))).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)this.getColorAndEmptyProperties().getA(), (Comparable)DyeColor.WHITE)).setValue((Property)this.getColorAndEmptyProperties().getB(), (Comparable)Boolean.valueOf(true))).setValue((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean isCorrupted() {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ModStateProperties.FACING, ModStateProperties.FLIPPED, ModStateProperties.SHEARED, this.getAgeProperty(), (Property)this.getColorAndEmptyProperties().getA(), (Property)this.getColorAndEmptyProperties().getB()});
    }

    public BlockState updateShape(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (this.canSurvive(state, (LevelReader)level, pCurrentPos)) {
            return (BlockState)state.setValue((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(pCurrentPos.getY() % 2 == 0));
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos().below());
        if (state.is((Block)this)) {
            return (BlockState)state.setValue((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(context.getClickedPos().getY() % 2 == 0));
        }
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(context.getClickedPos().getY() % 2 == 0))).setValue((Property)ModStateProperties.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = level.getBlockState(blockPos);
        BlockPos wallPos = pos.relative(((Direction)state.getValue((Property)ModStateProperties.FACING)).getOpposite());
        BlockState wallState = level.getBlockState(wallPos);
        return (blockState.is((Block)ModBlocks.CAULORFLOWER.get()) || blockState.is((Block)ModBlocks.PATTERNFLOWER.get())) && this.getAge(blockState) > 0 || blockState.isFaceSturdy((BlockGetter)level, blockPos, Direction.UP) || wallState.isFaceSturdy((BlockGetter)level, wallPos, (Direction)state.getValue((Property)ModStateProperties.FACING));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        if ((double)random.nextFloat() < 0.15 && !((Boolean)state.getValue((Property)ModStateProperties.SHEARED)).booleanValue()) {
            this.grow(level, pos, false);
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        Optional<BlockPos> highestPos = this.highestPos((BlockGetter)level, pos, true);
        if (highestPos.isPresent()) {
            BlockState blockState = level.getBlockState(highestPos.get());
            return level.getBlockState(highestPos.get().above()).is(Blocks.AIR) || blockState.hasProperty((Property)this.getAgeProperty()) && !this.isMaxAge(blockState);
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.grow(level, pos, true);
    }

    protected void grow(ServerLevel level, BlockPos originalPos, boolean bonemeal) {
        if (!this.isMaxAge(level.getBlockState(originalPos))) {
            this.makeGrowOnBonemeal((Level)level, originalPos, level.getBlockState(originalPos));
        } else {
            this.highestPos((BlockGetter)level, originalPos, bonemeal).ifPresent(highestPos -> {
                BlockPos posBelow = highestPos.below();
                BlockState stateBelow = level.getBlockState(posBelow);
                if (this.isMaxAge(stateBelow)) {
                    level.setBlockAndUpdate(highestPos, (BlockState)((BlockState)this.withPropertiesOf(stateBelow).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(highestPos.getY() % 2 == 0)));
                } else {
                    this.makeGrowOnBonemeal((Level)level, posBelow, stateBelow);
                }
            });
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.shear(player, level, pos, hand)) {
            return ItemInteractionResult.SUCCESS;
        }
        return this.harvestable(state) && stack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.harvestable(state)) {
            this.popResource(level, pos, state);
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(1));
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void popResource(Level level, BlockPos pos, BlockState state) {
        CaulorflowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)Dye.stackFromDye(new Dye((DyeColor)state.getValue(ModStateProperties.COLOR), 1)));
    }

    public boolean harvestable(BlockState blockState) {
        return this.isMaxAge(blockState) && !this.getDyeFromBlock(blockState).isEmpty();
    }

    public Optional<BlockPos> highestPos(BlockGetter level, BlockPos originalPos, boolean bonemeal) {
        Optional<BlockPos> lowestPos = this.getLowestPos(level, originalPos);
        if (lowestPos.isEmpty()) {
            return Optional.empty();
        }
        Optional<BlockPos> highestPos = this.getLastConnectedBlock(level, lowestPos.get(), Direction.UP);
        return highestPos.filter(blockPos1 -> bonemeal || ((BlockPos)lowestPos.get()).getY() + 5 > blockPos1.getY()).map(BlockPos::above);
    }

    public Optional<BlockPos> getLowestPos(BlockGetter level, BlockPos originalPos) {
        Optional<BlockPos> posDown = this.getLastConnectedBlock(level, originalPos, Direction.DOWN).map(BlockPos::above);
        return posDown.filter(blockPos -> level.getBlockState(blockPos).is((Block)this));
    }

    public Optional<BlockPos> getLastConnectedBlock(BlockGetter pGetter, BlockPos pos, Direction pDirection) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        while (pGetter.getBlockState((BlockPos)blockpos$mutableblockpos).is((Block)this)) {
            blockpos$mutableblockpos.move(pDirection);
        }
        return pDirection == Direction.DOWN ? Optional.of(blockpos$mutableblockpos) : (pGetter.getBlockState((BlockPos)blockpos$mutableblockpos).is(Blocks.AIR) ? Optional.of(blockpos$mutableblockpos.below()) : Optional.empty());
    }

    public BlockState mirror(BlockState state, Mirror pMirror) {
        return state.rotate(pMirror.getRotation((Direction)state.getValue((Property)ModStateProperties.FACING)));
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (newState.is((Block)this)) {
            return;
        }
        if (newState.is((Block)ModBlocks.PATTERNFLOWER.get())) {
            return;
        }
        BlockState stateBelow = level.getBlockState(pos.below());
        if (!stateBelow.is((Block)this) && !stateBelow.is(Blocks.AIR)) {
            CaulorflowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.CAULORFLOWER_SEEDS.get()));
        }
        if (!this.isColorEmpty(state) && this.isMaxAge(state)) {
            CaulorflowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)Dye.stackFromDye(new Dye((DyeColor)state.getValue(ModStateProperties.COLOR), 1)));
        }
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_2;
    }

    @Override
    public void colorBlock(Level level, BlockPos blockPos, BlockState blockState, Dye dye) {
        Colorable.super.colorBlock(level, blockPos, (BlockState)blockState.setValue((Property)this.getColorAndEmptyProperties().getB(), (Comparable)Boolean.valueOf(false)), dye);
        Player player = level.getNearestPlayer((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 6.0, false);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((SimpleAdvancementTrigger)((Object)ModAdvancementCritters.USED_DYESPRIA.get())).trigger(serverPlayer);
        }
    }

    @Override
    public boolean canBeColored(BlockState blockState, Dye dye) {
        return Colorable.super.canBeColored(blockState, dye) || Colorable.super.isColorEmpty(blockState);
    }

    @Override
    public Map<DyeColor, Integer> colorValues() {
        Map<DyeColor, Integer> map = Colorable.super.colorValues();
        map.put(DyeColor.WHITE, -1);
        map.put(DyeColor.LIGHT_GRAY, -6449253);
        map.put(DyeColor.GRAY, -12103854);
        map.put(DyeColor.BLACK, -14277074);
        map.put(DyeColor.BROWN, -8170446);
        map.put(DyeColor.RED, -2796466);
        map.put(DyeColor.ORANGE, -485835);
        map.put(DyeColor.YELLOW, -4525);
        map.put(DyeColor.LIME, -8337633);
        map.put(DyeColor.GREEN, -10585066);
        map.put(DyeColor.CYAN, -16733492);
        map.put(DyeColor.LIGHT_BLUE, -9381404);
        map.put(DyeColor.BLUE, -12102740);
        map.put(DyeColor.PURPLE, -5152830);
        map.put(DyeColor.MAGENTA, -2984263);
        map.put(DyeColor.PINK, -479036);
        return map;
    }

    @Override
    public void onAddDye(@Nullable ItemStack destinationStack, ItemStack dye, int amount) {
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.onCorruptByEntity(entity, pos, state, this, level);
    }

    @Override
    public void onCorrupt(Level level, BlockPos pos, BlockState oldState, Block corruptedBlock) {
        BlockState corruptedState = corruptedBlock.withPropertiesOf((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)corruptedBlock.defaultBlockState().setValue((Property)ModStateProperties.FACING, (Comparable)((Direction)oldState.getValue((Property)ModStateProperties.FACING)))).setValue((Property)ModStateProperties.FLIPPED, (Comparable)((Boolean)oldState.getValue((Property)ModStateProperties.FLIPPED)))).setValue((Property)ModStateProperties.AGE_2, (Comparable)((Integer)oldState.getValue((Property)ModStateProperties.AGE_2)))).setValue(ModStateProperties.BLOCK_PATTERN, (Comparable)((Object)((Boolean)oldState.getValue((Property)ModStateProperties.EMPTY) != false ? BlockPattern.EMPTY : BlockPattern.fromDyeColor((DyeColor)oldState.getValue(ModStateProperties.COLOR)))))).setValue((Property)ModStateProperties.EMPTY, (Comparable)((Boolean)oldState.getValue((Property)ModStateProperties.EMPTY))));
        level.setBlockAndUpdate(pos, corruptedState);
    }
}

