/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.GiantCropBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Bonmeelable;
import net.abraxator.moresnifferflowers.blocks.ModEntityBlock;
import net.abraxator.moresnifferflowers.client.model.block.SimpleModels;
import net.abraxator.moresnifferflowers.client.renderer.custom.GhostBlockRenderer;
import net.abraxator.moresnifferflowers.client.renderer.custom.GhostModelRenderer;
import net.abraxator.moresnifferflowers.components.RenderOffsetType;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.init.SimpleAdvancementTrigger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.components.SyncedStatePropertiesBuilder;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import vectorwing.farmersdelight.common.block.RiceBlock;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;

public class GiantCropBlock
extends AbstractMultiBlock
implements ModEntityBlock,
Bonmeelable,
IPreviewableMultiblock,
SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE_POTATO = GiantCropBlock.makeShapePotato();
    public static final VoxelShape SHAPE_CARROT = GiantCropBlock.makeShapeCarrot();
    public static final VoxelShape SHAPE_BEET = GiantCropBlock.makeShapeBeet();
    public static final VoxelShape SHAPE_NETHERWART = GiantCropBlock.makeShapeWart();
    public static final VoxelShape SHAPE_WHEAT = GiantCropBlock.makeShapeWheat();
    public static final VoxelShape SHAPE_ONION = GiantCropBlock.makeShapeOnion();
    public static final VoxelShape SHAPE_TOMATO = GiantCropBlock.makeShapeTomato();
    public static final VoxelShape SHAPE_CABBAGE = GiantCropBlock.makeShapeCabbage();
    public static final VoxelShape SHAPE_RICE = GiantCropBlock.makeShapeRice();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BlockBehaviour.StatePredicate STATE_PREDICATE = (p_152641_, p_152642_, p_152643_) -> (Boolean)p_152641_.getValue((Property)AbstractMultiBlock.CENTER);
    public final SyncedStatePropertiesBuilder PROPERTIES_BUILDER = new SyncedStatePropertiesBuilder();

    public GiantCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public SyncedStatePropertiesBuilder getSyncedStatePropertiesBuilder() {
        return this.PROPERTIES_BUILDER;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public List<BlockPos> makeFullBlockShape(@Nullable Direction direction, BlockPos center, BlockState blockState) {
        if (this.equals(ModBlocks.GIANT_CABBAGE.get())) {
            return IMultiBlock.posStreamToList((Stream)BlockPos.betweenClosedStream((int)(center.getX() - 1), (int)(center.getY() - 1), (int)(center.getZ() - 1), (int)(center.getX() + 1), (int)center.getY(), (int)(center.getZ() + 1)));
        }
        return IMultiBlock.posStreamToList((Stream)BlockPos.betweenClosedStream((int)(center.getX() - 1), (int)(center.getY() - 1), (int)(center.getZ() - 1), (int)(center.getX() + 1), (int)(center.getY() + 1), (int)(center.getZ() + 1)));
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GiantCropBlockEntity) {
            GiantCropBlockEntity entity = (GiantCropBlockEntity)blockEntity;
            if (entity.state == 1) {
                entity.canGrow = true;
            }
        }
    }

    public RenderShape getMultiblockRenderShape(BlockState state) {
        if (!IMultiBlock.isCenter((BlockState)state)) {
            return RenderShape.INVISIBLE;
        }
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean canPlace(LevelReader level, BlockPos center, BlockState state, @Nullable Entity player, boolean ignoreEntities) {
        return true;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public ItemStack pickupBlock(@javax.annotation.Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        return super.pickupBlock(player, level, pos, state);
    }

    public boolean canPlaceLiquid(@javax.annotation.Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (!this.defaultBlockState().is(ModTags.ModBlockTags.WATERLOGGABLE)) {
            return false;
        }
        return super.canPlaceLiquid(player, level, pos, state, fluid);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pMovedByPiston) {
        super.onPlace(state, level, pos, pOldState, pMovedByPiston);
        if (IMultiBlock.isCenter((BlockState)state)) {
            level.getBlockTicks().schedule(new ScheduledTick((Object)this, pos, level.getGameTime() + 7L, level.nextSubTickCount()));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof GiantCropBlockEntity) {
                GiantCropBlockEntity entity = (GiantCropBlockEntity)blockEntity;
                if (entity.state == 0) {
                    entity.state = 1;
                }
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.GIANT_CROP.get()), pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GiantCropBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> pBlockEntityType) {
        return (pLevel1, pos, pState1, blockEntity) -> {
            GiantCropBlockEntity blockEntity1 = (GiantCropBlockEntity)blockEntity;
            if (!blockEntity1.canGrow) {
                return;
            }
            if (!level.isClientSide) {
                blockEntity1.tick(level);
            }
        };
    }

    @Override
    public void performBonmeel(BlockPos blockPos, BlockState blockState, Level level, Player player) {
        if (GiantCropBlock.isRicePanicles(blockState.getBlock())) {
            blockPos = blockPos.below();
        }
        this.place(level, blockPos.above(), this.defaultBlockState());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((SimpleAdvancementTrigger)((Object)ModAdvancementCritters.USED_BONMEEL.get())).trigger(serverPlayer);
        }
        level.playLocalSound(blockPos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
    }

    public List<com.mojang.datafixers.util.Pair<BlockPos, BlockState>> prepareForPlace(Level level, BlockPos centerPos, BlockState stateOriginal) {
        ArrayList<com.mojang.datafixers.util.Pair<BlockPos, BlockState>> list = new ArrayList<com.mojang.datafixers.util.Pair<BlockPos, BlockState>>();
        this.getFullBlockShape(centerPos, stateOriginal, (BlockGetter)level).forEach(posNew -> {
            boolean isWaterLogged = level.getFluidState(posNew = posNew.immutable()).getType() == Fluids.WATER;
            BlockState stateNew = (BlockState)((BlockState)stateOriginal.setValue((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(centerPos.equals(posNew)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
            list.add(new com.mojang.datafixers.util.Pair(posNew, (Object)stateNew));
        });
        return list;
    }

    @Override
    public boolean canBonmeel(BlockPos blockPos, BlockState blockState, Level level, @Nullable Player player) {
        Block crop = blockState.getBlock();
        int cropY = blockPos.getY();
        if (GiantCropBlock.isRicePanicles(crop)) {
            blockPos = blockPos.below();
        }
        AtomicBoolean hasMixedCrops = new AtomicBoolean(false);
        AtomicBoolean notGrown = new AtomicBoolean(false);
        AtomicBoolean noSpace = new AtomicBoolean(false);
        boolean canRenderGhosts = player != null && level.isClientSide();
        boolean canBonmeel = this.getFullBlockShape(blockPos, blockState, (BlockGetter)level).stream().allMatch(pos -> {
            boolean hasFreeSpace;
            pos = pos.above();
            BlockState state = level.getBlockState(pos);
            IntegerProperty PROPERTY = (IntegerProperty)((Pair)GiantCropBlock.getCropMap().get(crop).getB()).getA();
            int MAX_AGE = (Integer)((Pair)GiantCropBlock.getCropMap().get(crop).getB()).getB();
            if (pos.getY() == cropY) {
                boolean isMaxAge;
                boolean isCorrectCrop;
                boolean bl = isCorrectCrop = state.is(crop) && state.is(ModTags.ModBlockTags.BONMEELABLE);
                if (!isCorrectCrop) {
                    hasMixedCrops.set(true);
                    return false;
                }
                boolean bl2 = isMaxAge = (Integer)state.getValue((Property)PROPERTY) == MAX_AGE;
                if (!isMaxAge) {
                    notGrown.set(true);
                    if (canRenderGhosts) {
                        new GhostBlockRenderer((BlockPos)pos, 40, (BlockState)state.setValue((Property)PROPERTY, (Comparable)Integer.valueOf(MAX_AGE))).setARGB(1.0f, 0.5f, 0.5f, 0.5f).enableFadeOut(20).setRenderOffsetType(RenderOffsetType.CROSS).addToRenderList();
                    }
                }
                return isMaxAge;
            }
            boolean bl = hasFreeSpace = state.canBeReplaced() || state.is(ModTags.ModBlockTags.GIANT_CROP_REPLACEABLE) || state.is(crop);
            if (!hasFreeSpace) {
                noSpace.set(true);
                if (canRenderGhosts) {
                    new GhostModelRenderer((BlockPos)pos, 40, SimpleModels.simpleCube().bakeRoot(), new Material(TextureAtlas.LOCATION_BLOCKS, MoreSnifferFlowers.loc("block/pure_white"))).setARGB(1.0f, 0.0f, 0.0f, 0.3f).enableFadeOut(20).setRenderOffsetType(RenderOffsetType.SCALED).addToRenderList();
                }
            }
            return hasFreeSpace;
        });
        if (!canBonmeel && player != null) {
            if (hasMixedCrops.get()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.moresnifferflowers.bonmeel.has_mixed_crops").withStyle(ChatFormatting.GRAY), true);
            } else if (notGrown.get()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.moresnifferflowers.bonmeel.not_grown").withStyle(ChatFormatting.GRAY), true);
            } else if (noSpace.get()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.moresnifferflowers.bonmeel.no_space").withStyle(ChatFormatting.GRAY), true);
            }
        }
        return canBonmeel;
    }

    private static boolean isRicePanicles(Block crop) {
        return crop.equals(BuiltInRegistries.BLOCK.get(MoreSnifferFlowers.farmersDelightLoc("rice_panicles")));
    }

    private static Map<Block, Pair<Block, Pair<IntegerProperty, Integer>>> cropMapCompat() {
        return Map.of(Blocks.CARROTS, new Pair((Object)((Block)ModBlocks.GIANT_CARROT.get()), (Object)new Pair((Object)CropBlock.AGE, (Object)7)), Blocks.POTATOES, new Pair((Object)((Block)ModBlocks.GIANT_POTATO.get()), (Object)new Pair((Object)CropBlock.AGE, (Object)7)), Blocks.NETHER_WART, new Pair((Object)((Block)ModBlocks.GIANT_NETHERWART.get()), (Object)new Pair((Object)NetherWartBlock.AGE, (Object)3)), Blocks.BEETROOTS, new Pair((Object)((Block)ModBlocks.GIANT_BEETROOT.get()), (Object)new Pair((Object)BeetrootBlock.AGE, (Object)3)), Blocks.WHEAT, new Pair((Object)((Block)ModBlocks.GIANT_WHEAT.get()), (Object)new Pair((Object)CropBlock.AGE, (Object)7)), (Block)BuiltInRegistries.BLOCK.get(MoreSnifferFlowers.farmersDelightLoc("onions")), new Pair((Object)((Block)ModBlocks.GIANT_ONION.get()), (Object)new Pair((Object)CropBlock.AGE, (Object)7)), (Block)BuiltInRegistries.BLOCK.get(MoreSnifferFlowers.farmersDelightLoc("tomatoes")), new Pair((Object)((Block)ModBlocks.GIANT_TOMATO.get()), (Object)new Pair((Object)TomatoVineBlock.VINE_AGE, (Object)3)), (Block)BuiltInRegistries.BLOCK.get(MoreSnifferFlowers.farmersDelightLoc("cabbages")), new Pair((Object)((Block)ModBlocks.GIANT_CABBAGE.get()), (Object)new Pair((Object)CropBlock.AGE, (Object)7)), (Block)BuiltInRegistries.BLOCK.get(MoreSnifferFlowers.farmersDelightLoc("rice_panicles")), new Pair((Object)((Block)ModBlocks.GIANT_RICE.get()), (Object)new Pair((Object)RiceBlock.AGE, (Object)3)));
    }

    private static Map<Block, Pair<Block, Pair<IntegerProperty, Integer>>> cropMapVanilla() {
        return Map.of(Blocks.CARROTS, new Pair((Object)((Block)ModBlocks.GIANT_CARROT.get()), (Object)new Pair((Object)CropBlock.AGE, (Object)7)), Blocks.POTATOES, new Pair((Object)((Block)ModBlocks.GIANT_POTATO.get()), (Object)new Pair((Object)CropBlock.AGE, (Object)7)), Blocks.NETHER_WART, new Pair((Object)((Block)ModBlocks.GIANT_NETHERWART.get()), (Object)new Pair((Object)NetherWartBlock.AGE, (Object)3)), Blocks.BEETROOTS, new Pair((Object)((Block)ModBlocks.GIANT_BEETROOT.get()), (Object)new Pair((Object)BeetrootBlock.AGE, (Object)3)), Blocks.WHEAT, new Pair((Object)((Block)ModBlocks.GIANT_WHEAT.get()), (Object)new Pair((Object)CropBlock.AGE, (Object)7)));
    }

    public static Map<Block, Pair<Block, Pair<IntegerProperty, Integer>>> getCropMap() {
        return MoreSnifferFlowers.hasFarmersDelight() ? GiantCropBlock.cropMapCompat() : GiantCropBlock.cropMapVanilla();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.block();
        if (IMultiBlock.getXOffset((BlockGetter)getter, (BlockPos)pos) == 0 && IMultiBlock.getZOffset((BlockGetter)getter, (BlockPos)pos) == 0) {
            return shape;
        }
        if (this.equals(ModBlocks.GIANT_POTATO.get())) {
            shape = SHAPE_POTATO;
        }
        if (this.equals(ModBlocks.GIANT_CARROT.get())) {
            shape = SHAPE_CARROT;
        }
        if (this.equals(ModBlocks.GIANT_BEETROOT.get())) {
            shape = SHAPE_BEET;
        }
        if (this.equals(ModBlocks.GIANT_NETHERWART.get())) {
            shape = SHAPE_NETHERWART;
        }
        if (this.equals(ModBlocks.GIANT_WHEAT.get())) {
            shape = SHAPE_WHEAT;
        }
        if (this.equals(ModBlocks.GIANT_ONION.get())) {
            shape = SHAPE_ONION;
        }
        if (this.equals(ModBlocks.GIANT_TOMATO.get())) {
            shape = SHAPE_TOMATO;
        }
        if (this.equals(ModBlocks.GIANT_CABBAGE.get())) {
            shape = SHAPE_CABBAGE;
        }
        if (this.equals(ModBlocks.GIANT_RICE.get())) {
            shape = SHAPE_RICE;
        }
        return this.voxelShapeHelper(state, getter, pos, shape, 0.0f, -1.0f, 0.0f);
    }

    public static VoxelShape makeShapePotato() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.4375, (double)-0.0625, (double)-0.4375, (double)1.4375, (double)2.125, (double)1.4375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.3125, (double)2.125, (double)-0.3125, (double)1.3125, (double)2.375, (double)1.3125), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeWheat() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.5625, (double)-0.0625, (double)-0.5625, (double)1.5625, (double)2.9375, (double)1.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeCarrot() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.6875, (double)-0.0625, (double)-0.6875, (double)1.6875, (double)0.4375, (double)1.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.4375, (double)0.375, (double)-0.4375, (double)1.4375, (double)1.875, (double)1.4375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeWart() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.5625, (double)1.25, (double)-0.5625, (double)1.5625, (double)3.0, (double)1.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.125, (double)0.0, (double)-0.125, (double)1.125, (double)1.25, (double)1.125), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeBeet() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.375, (double)-0.0625, (double)-0.375, (double)1.375, (double)1.75, (double)1.375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeCabbage() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.5625, (double)0.0, (double)-0.5625, (double)1.5625, (double)1.5, (double)1.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeOnion() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.33, (double)0.0, (double)-0.325, (double)1.3, (double)2.0, (double)1.3), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeTomato() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.437, (double)-0.0625, (double)-0.405, (double)1.4375, (double)1.8125, (double)1.465), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeRice() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)2.5, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.1875, (double)-0.0625, (double)-0.1875, (double)1.1875, (double)0.8125, (double)1.1875), (BooleanOp)BooleanOp.OR);
        return shape;
    }
}

