/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;

public interface ModCropBlock
extends BonemealableBlock {
    public IntegerProperty getAgeProperty();

    default public boolean isMaxAge(BlockState blockState) {
        return this.getAge(blockState) >= this.getMaxAge();
    }

    default public int getMaxAge() {
        return (Integer)this.getAgeProperty().getPossibleValues().stream().toList().get(this.getAgeProperty().getPossibleValues().size() - 1);
    }

    default public int getAge(BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.getAgeProperty());
    }

    default public void makeGrowOnTick(BlockState blockState, Level level, BlockPos blockPos) {
        if (((Boolean)blockState.getValue((Property)ModStateProperties.SHEARED)).booleanValue()) {
            return;
        }
        if (!this.isMaxAge(blockState) && level.isAreaLoaded(blockPos, 1) && level.getRawBrightness(blockPos, 0) >= 9) {
            float f = ModCropBlock.getGrowthSpeed(blockState, (BlockGetter)level, blockPos);
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)blockPos, (BlockState)blockState, (level.getRandom().nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)this.getAgeProperty()) + 1)), 2);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            }
        }
    }

    default public void makeGrowOnBonemeal(Level level, BlockPos blockPos, BlockState blockState) {
        level.setBlock(blockPos, (BlockState)blockState.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.isMaxAge(blockState) ? this.getAge(blockState) : this.getAge(blockState) + 1)), 2);
    }

    default public boolean mayPlaceOn(BlockState state) {
        return state.is(Blocks.FARMLAND) || state.getBlock() instanceof FarmBlock || state.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"supplementaries", (String)"planters")));
    }

    private static void shear(Player player, Level level, BlockPos blockPos, BlockState blockState, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockPos, player.getItemInHand(hand));
        }
        level.setBlockAndUpdate(blockPos, (BlockState)blockState.trySetValue((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(true)));
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
        level.playSound(null, blockPos, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
    }

    default public boolean shear(Player player, Level level, BlockPos blockPos, InteractionHand hand) {
        BlockState blockState = level.getBlockState(blockPos);
        if (player.getItemInHand(hand).is(Tags.Items.TOOLS_SHEAR) && !((Boolean)blockState.getValue((Property)ModStateProperties.SHEARED)).booleanValue()) {
            ModCropBlock.shear(player, level, blockPos, blockState, hand);
            return true;
        }
        return false;
    }

    public static float getGrowthSpeed(BlockState blockState, BlockGetter p_52274_, BlockPos p_52275_) {
        boolean flag1;
        Block p_52273_ = blockState.getBlock();
        float f = 1.0f;
        BlockPos blockpos = p_52275_.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = p_52274_.getBlockState(blockpos.offset(i, 0, j));
                TriState soilDecision = blockstate.canSustainPlant(p_52274_, blockpos.offset(i, 0, j), Direction.UP, blockState);
                if (soilDecision.isDefault() ? blockstate.getBlock() instanceof FarmBlock : soilDecision.isTrue()) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(p_52274_, p_52275_.offset(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = p_52275_.north();
        BlockPos blockpos2 = p_52275_.south();
        BlockPos blockpos3 = p_52275_.west();
        BlockPos blockpos4 = p_52275_.east();
        boolean flag = p_52274_.getBlockState(blockpos3).is(p_52273_) || p_52274_.getBlockState(blockpos4).is(p_52273_);
        boolean bl = flag1 = p_52274_.getBlockState(blockpos1).is(p_52273_) || p_52274_.getBlockState(blockpos2).is(p_52273_);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = p_52274_.getBlockState(blockpos3.north()).is(p_52273_) || p_52274_.getBlockState(blockpos4.north()).is(p_52273_) || p_52274_.getBlockState(blockpos4.south()).is(p_52273_) || p_52274_.getBlockState(blockpos3.south()).is(p_52273_);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public record PosAndState(BlockPos blockPos, BlockState state) {
    }
}

