/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blocks.IModEntityDoubleTallBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModEntityDoubleTallBlock
extends Block
implements IModEntityDoubleTallBlock {
    protected BlockPos ENTITY_POS;

    public ModEntityDoubleTallBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.isCreative()) {
                this.preventCreativeDropFromBottomPart(level, pos, state, player);
            } else {
                BlockEntity blockEntity = this.isUpper(state) ? level.getBlockEntity(pos) : null;
                ModEntityDoubleTallBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack pTool) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, pTool);
    }

    public void onRemove(@NotNull BlockState state, Level level, BlockPos pos, @NotNull BlockState pNewState, boolean pMovedByPiston) {
        if (this.isUpper(state)) {
            Containers.dropContentsOnDestroy((BlockState)state, (BlockState)pNewState, (Level)level, (BlockPos)pos);
        }
        super.onRemove(state, level, pos, pNewState, pMovedByPiston);
    }

    public BlockState updateShape(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing.getAxis() != Direction.Axis.Y || this.isLower(state) != (pFacing == Direction.UP) || this.isStateThis(pFacingState) && !this.areTwoHalfSame(state, pFacingState)) {
            return this.isLower(state) && pFacing == Direction.DOWN && !this.canSurvive(state, (LevelReader)level, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, pFacing, pFacingState, level, pCurrentPos, pFacingPos);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (this.isLower(state)) {
            return super.canSurvive(state, level, pos);
        }
        BlockState blockstate = level.getBlockState(pos.below());
        if (!this.isStateThis(state)) {
            return super.canSurvive(state, level, pos);
        }
        return this.isStateThis(blockstate) && this.isLower(blockstate);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        return blockPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockPos.above()).canBeReplaced(context) ? super.getStateForPlacement(context) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity pPlacer, ItemStack stack) {
        level.setBlockAndUpdate(pos.above(), this.getUpperBlock().defaultBlockState());
    }

    public void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPosBelow;
        BlockState blockStateBelow;
        if (this.isUpper(state) && this.isStateThis(blockStateBelow = level.getBlockState(blockPosBelow = pos.below())) && this.isLower(blockStateBelow)) {
            BlockState blockStateForReplacement = blockStateBelow.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(blockPosBelow, blockStateForReplacement, 35);
            level.levelEvent(player, 2001, blockPosBelow, Block.getId((BlockState)blockStateBelow));
        }
    }
}

