/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.corrupted;

import com.mojang.serialization.MapCodec;
import net.abraxator.moresnifferflowers.capability.CorruptionCapability;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStatePropertiesUnsafe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CuredGrassBlock
extends SpreadingSnowyDirtBlock {
    public static final MapCodec<CuredGrassBlock> CODEC = CuredGrassBlock.simpleCodec(CuredGrassBlock::new);

    public CuredGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends SpreadingSnowyDirtBlock> codec() {
        return CODEC;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity pEntity) {
        double d0 = Math.abs(pEntity.getDeltaMovement().y);
        if (d0 < 0.1 && !pEntity.isSteppingCarefully()) {
            double d1 = 0.8;
            pEntity.setDeltaMovement(pEntity.getDeltaMovement().multiply(d1, 1.0, d1));
        }
    }

    private static boolean canBeGrass(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = levelReader.getBlockState(blockpos);
        if (blockstate.is(Blocks.SNOW) && (Integer)blockstate.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)levelReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)levelReader, blockpos));
        return i < levelReader.getMaxLightLevel();
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!CuredGrassBlock.canBeGrass(state, (LevelReader)level, pos)) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            level.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
        } else {
            AABB aabb;
            boolean noCorruption;
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            BlockState blockstate = this.defaultBlockState();
            CorruptionCapability.cure(level.getChunkAt(pos));
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos = pos.offset(random.nextIntBetweenInclusive(-1, 1), random.nextIntBetweenInclusive(-3, 8), random.nextIntBetweenInclusive(-1, 1));
                BlockState state1 = level.getBlockState(blockpos);
                if (state1.is((Block)ModBlocks.CORRUPTED_GRASS_BLOCK.get())) {
                    level.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(blockpos.above()).is(Blocks.SNOW))));
                }
                if (!state1.getOptionalValue((Property)ModStatePropertiesUnsafe.NOT_CURED).isPresent()) continue;
                if (!((Boolean)state1.getValue((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED)).booleanValue()) {
                    level.setBlockAndUpdate(blockpos, (BlockState)((BlockState)state1.setValue((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED, (Comparable)Boolean.valueOf(true))).setValue((Property)ModStatePropertiesUnsafe.NOT_CURED, (Comparable)Boolean.valueOf(false)));
                }
                if (((Boolean)state1.getValue((Property)ModStatePropertiesUnsafe.NOT_CURED)).booleanValue()) continue;
                level.setBlockAndUpdate(blockpos, (BlockState)((BlockState)state1.setValue((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED, (Comparable)Boolean.valueOf(true))).setValue((Property)ModStatePropertiesUnsafe.NOT_CURED, (Comparable)Boolean.valueOf(true)));
            }
            if (level.getBlockState(pos.above()).is((Block)ModBlocks.CORRUPTED_GRASS.get())) {
                level.setBlock(pos.above(), Blocks.SHORT_GRASS.defaultBlockState(), 18);
            }
            if (level.getBlockState(pos.above()).is((Block)ModBlocks.CORRUPTED_TALL_GRASS.get())) {
                level.setBlock(pos.above(), (BlockState)Blocks.TALL_GRASS.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 18);
                level.setBlock(pos.above(2), (BlockState)Blocks.TALL_GRASS.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 18);
            }
            if (noCorruption = BlockPos.betweenClosedStream((AABB)(aabb = AABB.ofSize((Vec3)pos.getCenter(), (double)4.0, (double)4.0, (double)4.0))).allMatch(blockPos -> {
                if (level.getBlockState(blockPos).is((Block)ModBlocks.CORRUPTED_GRASS_BLOCK.get())) {
                    level.setBlockAndUpdate(blockPos, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(blockPos.above()).is(Blocks.SNOW))));
                    return false;
                }
                return true;
            })) {
                level.setBlockAndUpdate(pos, (BlockState)Blocks.GRASS_BLOCK.defaultBlockState().setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(pos.above()).is(Blocks.SNOW))));
            }
        }
    }
}

