/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.multiblock;

import net.abraxator.moresnifferflowers.data.datamaps.Corruptable;
import net.abraxator.moresnifferflowers.entities.CorruptedProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public interface ICorruptableMultiblock
extends IMultiBlock {
    public Block getCuredBlock();

    public Block getCorruptedBlock();

    default public boolean allBlocksPresent(LevelReader level, BlockPos pos, BlockState state) {
        IMultiBlockEntity entity;
        BlockEntity blockEntity;
        if (level.isClientSide()) {
            return true;
        }
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, (BlockPos)pos);
        boolean ret = this.getFullBlockShape(center, state, (BlockGetter)level).stream().allMatch(blockPos -> level.getBlockState(blockPos).is(this.getCuredBlock()) || level.getBlockState(blockPos).is(this.getCorruptedBlock()));
        if (ret && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)blockEntity).isPlaced()) {
            this.getFullBlockShape(center, state, (BlockGetter)level).forEach(blockPos -> IMultiBlockEntity.setPlaced((LevelReader)level, (BlockPos)blockPos, (boolean)true));
        }
        return ret;
    }

    default public void corruptionHelper(BlockState state, Level level, BlockPos pos, Entity entityInside) {
        if (entityInside instanceof CorruptedProjectile) {
            BlockEntity blockEntity;
            CorruptedProjectile corruptedProjectile = (CorruptedProjectile)entityInside;
            if (Corruptable.canBeCorrupted(state.getBlock(), level.random) && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
                corruptedProjectile.discard();
                BlockPos centrePos = entity.getCenter();
                BlockState centreState = level.getBlockState(centrePos);
                this.getFullBlockShape(entity.getCenter(), state, (BlockGetter)level).forEach(pos1 -> this.afterCorruption(centrePos, level, (BlockPos)pos1));
            }
        }
    }

    default public void afterCorruption(BlockPos centrePos, Level level, BlockPos pos) {
        if (!Corruptable.canBeCorrupted(level.getBlockState(pos).getBlock(), level.random)) {
            return;
        }
        Block corruptedBlock = Corruptable.getCorruptedBlock(level.getBlockState(pos).getBlock(), level.getRandom()).get();
        level.setBlockAndUpdate(pos, corruptedBlock.withPropertiesOf(level.getBlockState(pos)));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            entity.setCenter(centrePos);
        }
    }
}

