/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.vivicus;

import net.abraxator.moresnifferflowers.blocks.ColorableVivicusBlock;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTreeGrowers;
import net.abraxator.moresnifferflowers.worldgen.configurations.tree.vivicus.VivicusTreeGrower;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class VivicusSaplingBlock
extends SaplingBlock
implements ColorableVivicusBlock {
    public final VivicusTreeGrower vivicusTreeGrower = ModTreeGrowers.VIVICUS_TREE;

    public VivicusSaplingBlock(BlockBehaviour.Properties p_55979_) {
        super(TreeGrower.OAK, p_55979_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(ModStateProperties.COLOR, (Comparable)DyeColor.WHITE)).setValue((Property)ModStateProperties.VIVICUS_CURED, (Comparable)Boolean.valueOf(false)));
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pMovedByPiston) {
        DyeColor dyeColor = (DyeColor)Util.getRandom((Object[])DyeColor.values(), (RandomSource)level.random);
        if (pOldState.is((Block)this)) {
            dyeColor = this.getDyeFromBlock(state).color();
        }
        level.setBlock(pos, (BlockState)state.setValue(ModStateProperties.COLOR, (Comparable)dyeColor), 3);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ModStateProperties.COLOR});
        builder.add(new Property[]{ModStateProperties.VIVICUS_CURED});
    }

    public void advanceTree(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        if ((Integer)state.getValue((Property)STAGE) == 0) {
            level.setBlock(pos, (BlockState)state.cycle((Property)STAGE), 4);
        } else {
            this.vivicusTreeGrower.growTree(level, level.getChunkSource().getGenerator(), pos, state, random);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.stateForPlacementHelper(super.getStateForPlacement(context), context);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.cloneItemStackHelper(state, super.getCloneItemStack(level, pos, state));
    }
}

