/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.vivicus;

import net.abraxator.moresnifferflowers.blocks.ColorableVivicusBlock;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.entities.BoblingEntity;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;

public class VivicusSproutingBlock
extends Block
implements ModCropBlock,
ColorableVivicusBlock {
    private static final VoxelShape SHAPE0 = Block.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE1 = Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE2 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public VivicusSproutingBlock(BlockBehaviour.Properties p_54422_) {
        super(p_54422_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ModStateProperties.VIVICUS_CURED, (Comparable)Boolean.valueOf(false))).setValue(ModStateProperties.COLOR, (Comparable)DyeColor.WHITE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ModStateProperties.AGE_3});
        builder.add(new Property[]{ModStateProperties.VIVICUS_CURED});
        builder.add(new Property[]{ModStateProperties.COLOR});
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_3;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return super.isRandomlyTicking(state) || !this.isMaxAge(state);
    }

    public void grow(BlockState state, Level level, BlockPos pos) {
        this.makeGrowOnBonemeal(level, pos, state);
        if (this.isMaxAge(level.getBlockState(pos))) {
            BoblingEntity boblingEntity = new BoblingEntity(level, (Boolean)state.getValue((Property)ModStateProperties.VIVICUS_CURED));
            boblingEntity.setPos(pos.getCenter());
            level.addFreshEntity((Entity)boblingEntity);
            level.removeBlock(pos, false);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        TriState soilDecision = level.getBlockState(pos.above()).canSustainPlant((BlockGetter)level, pos.above(), Direction.DOWN, state);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return level.getBlockState(pos.above()).is((Block)ModBlocks.VIVICUS_LEAVES.get());
    }

    public BlockState updateShape(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == Direction.UP && !state.canSurvive((LevelReader)level, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, pFacing, pFacingState, level, pCurrentPos, pFacingPos);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextDouble() <= 0.5) {
            this.grow(state, (Level)level, pos);
        }
        super.randomTick(state, level, pos, random);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.grow(state, (Level)level, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return switch ((Integer)state.getValue((Property)ModStateProperties.AGE_3)) {
            case 1 -> SHAPE1.move(vec3.x, vec3.y, vec3.z);
            case 2 -> SHAPE2.move(vec3.x, vec3.y, vec3.z);
            default -> SHAPE0.move(vec3.x, vec3.y, vec3.z);
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.stateForPlacementHelper(super.getStateForPlacement(context), context);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.cloneItemStackHelper(state, super.getCloneItemStack(level, pos, state));
    }
}

