/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.xbush;

import java.util.Optional;
import net.abraxator.moresnifferflowers.blockentities.XbushBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModEntityDoubleTallBlock;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXBushBlockBase
extends ModEntityDoubleTallBlock
implements ModCropBlock,
Corruptable {
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final int AGE_TO_GROW_UP = 4;

    public AbstractXBushBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_8;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return !this.isMaxAge(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity;
        if (this.isUpper(state) && (blockEntity = level.getBlockEntity(pos)) instanceof XbushBlockEntity) {
            XbushBlockEntity entity = (XbushBlockEntity)blockEntity;
            if (entity.hasGrown) {
                return super.getShape(state, level, pos, context);
            }
        }
        return SHAPE;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(level.getBlockState(pos.below())) && this.sufficientLight(level, pos) && super.canSurvive(state, level, pos);
    }

    @Override
    public boolean mayPlaceOn(BlockState state) {
        return ModCropBlock.super.mayPlaceOn(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ModStateProperties.AGE_8});
        builder.add(new Property[]{ModStateProperties.SHEARED});
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity pEntity) {
        if (pEntity instanceof Ravager && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            level.destroyBlock(pos, true, pEntity);
        }
        super.entityInside(state, level, pos, pEntity);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext pUseContext) {
        return false;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.getAge(state) == 7 && random.nextInt(100) < 10 && this.isLower(state)) {
            level.addAlwaysVisibleParticle((ParticleOptions)ModParticles.AMBUSH.get(), true, (double)pos.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + random.nextDouble() + random.nextDouble(), (double)pos.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)ModStateProperties.SHEARED)).booleanValue()) {
            return;
        }
        float f = ModCropBlock.getGrowthSpeed(state, (BlockGetter)level, pos);
        if (random.nextInt((int)(25.0f / f + 1.0f)) == 0) {
            this.grow(level, state, pos, 1);
        }
    }

    public void grow(ServerLevel level, BlockState state, BlockPos pos, int i) {
        int k = Math.min(this.getAge(state) + i, this.getMaxAge());
        if (this.canGrow((LevelReader)level, pos, state, k) && level.getRandom().nextFloat() < 0.6f) {
            level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(k)), 2);
            if (k >= 4 && this.isLower(state)) {
                level.setBlock(pos.above(), (BlockState)this.getUpperBlock().defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(k)), 3);
            }
            this.getLowerHalf((LevelReader)level, pos, state).ifPresent(posAndState -> {
                BlockEntity patt0$temp = level.getBlockEntity(posAndState.blockPos().above());
                if (patt0$temp instanceof XbushBlockEntity) {
                    XbushBlockEntity entity = (XbushBlockEntity)patt0$temp;
                    entity.growProgress = 0.0f;
                }
            });
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.shear(player, level, pos, hand)) {
            return ItemInteractionResult.SUCCESS;
        }
        int k = Math.min(this.getAge(state) + 1, this.getMaxAge());
        return stack.is(Items.BONE_MEAL) && this.canGrow((LevelReader)level, pos, state, k) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Optional<ModCropBlock.PosAndState> optional = this.getLowerHalf((LevelReader)level, pos, state);
        if (optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(optional.get().blockPos().above());
        if (blockEntity instanceof XbushBlockEntity) {
            XbushBlockEntity entity = (XbushBlockEntity)blockEntity;
            if (entity.hasGrown) {
                BlockPos lowerPos = this.isLower(state) ? pos : pos.below();
                AbstractXBushBlockBase.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getDropBlock()));
                level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                for (int i = 0; i <= 1; ++i) {
                    BlockPos halfPos = i == 0 ? lowerPos : lowerPos.above();
                    BlockState halfState = (BlockState)level.getBlockState(halfPos).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(7));
                    level.setBlock(halfPos, halfState, 3);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, halfPos, GameEvent.Context.of((Entity)player, (BlockState)halfState));
                }
                entity.reset();
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return InteractionResult.PASS;
    }

    private boolean canGrowInto(BlockState state) {
        return state.isAir() || state.is(this.getUpperBlock());
    }

    private boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) >= 8 || level.canSeeSky(pos);
    }

    @Override
    public int getMaxAge() {
        return ModCropBlock.super.getMaxAge() - 1;
    }

    private boolean canGrow(LevelReader level, BlockPos pos, BlockState state, int k) {
        return !this.isMaxAge(state) && this.sufficientLight(level, pos) && (k < 4 || this.canGrowInto(level.getBlockState(pos.above()))) && this.isLower(state);
    }

    @Override
    public void onCorrupt(Level level, BlockPos pos, BlockState oldState, Block corruptedBlock) {
        Optional<ModCropBlock.PosAndState> lowerHalf = this.getLowerHalf((LevelReader)level, pos, oldState);
        lowerHalf.ifPresent(posAndState -> {
            level.setBlockAndUpdate(posAndState.blockPos(), corruptedBlock.withPropertiesOf(oldState));
            if (this.getAge(((ModCropBlock.PosAndState)lowerHalf.get()).state()) > 3) {
                this.getCorruptedBlock(this.getUpperBlock(), level.getRandom()).ifPresent(block -> level.setBlockAndUpdate(posAndState.blockPos().above(), block.withPropertiesOf(level.getBlockState(posAndState.blockPos().above()))));
            }
        });
    }

    Optional<ModCropBlock.PosAndState> getLowerHalf(LevelReader level, BlockPos blockPos, BlockState state) {
        if (this.isLower(state)) {
            return Optional.of(new ModCropBlock.PosAndState(blockPos, state));
        }
        BlockPos posBelow = blockPos.below();
        BlockState stateBelow = level.getBlockState(posBelow);
        return this.isLower(stateBelow) ? Optional.of(new ModCropBlock.PosAndState(posBelow, stateBelow)) : Optional.empty();
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        Optional<ModCropBlock.PosAndState> posAndState = this.getLowerHalf(level, pos, state);
        return posAndState.isPresent() && this.canGrow(level, posAndState.get().blockPos(), posAndState.get().state(), this.getAge(posAndState.get().state()) + 1);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.getLowerHalf((LevelReader)level, pos, state).ifPresent(posAndState -> {
            if ((Integer)state.getValue((Property)ModStateProperties.AGE_8) < 8) {
                this.grow(level, posAndState.state(), posAndState.blockPos(), 1);
            }
        });
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity pPlacer, ItemStack stack) {
    }

    public abstract Block getDropBlock();
}

