/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.networking.toClient.SyncBlockPatternsPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.network.PacketDistributor;

public class BlockPatternCapability {
    public Map<BlockPos, PatternData> patterns;
    public static final Codec<Long> LONG_STRING_CODEC = Codec.STRING.xmap(Long::parseLong, Object::toString);
    public static final Codec<BlockPos> BLOCKPOS_LONG_CODEC = LONG_STRING_CODEC.xmap(BlockPos::of, BlockPos::asLong);
    public static final Codec<BlockPatternCapability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(BLOCKPOS_LONG_CODEC, PatternData.CODEC).fieldOf("patterns").forGetter(cap -> cap.patterns)).apply((Applicative)instance, BlockPatternCapability::new));
    public static final StreamCodec<? super ByteBuf, BlockPatternCapability> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)BlockPos.STREAM_CODEC, PatternData.STREAM_CODEC), cap -> cap.patterns, BlockPatternCapability::new);

    public BlockPatternCapability(Map<BlockPos, PatternData> patterns) {
        this.patterns = new HashMap<BlockPos, PatternData>(patterns);
    }

    public Map<BlockPos, PatternData> getPatterns() {
        return this.patterns;
    }

    public static BlockPatternCapability getBlockPatterns(BlockPos pos, Level level) {
        return BlockPatternCapability.getBlockPatterns(level.getChunkAt(pos));
    }

    public static BlockPatternCapability getBlockPatterns(LevelChunk chunk) {
        return (BlockPatternCapability)chunk.getData(ModDataAttachments.BLOCK_PATTERNS.get());
    }

    public static void setPattern(BlockPos pos, PatternData pattern, Level level) {
        level.getChunkAt(pos).setUnsaved(true);
        BlockPatternCapability capability = BlockPatternCapability.getBlockPatterns(pos, level);
        capability.setPattern(pos, pattern);
        if (!level.isClientSide) {
            capability.sync(pos, level);
        }
    }

    public void setPattern(BlockPos pos, PatternData pattern) {
        this.patterns.put(pos.immutable(), pattern);
    }

    public static void setBulkPatterns(Map<BlockPos, PatternData> patternMap, Level level) {
        if (level.isClientSide) {
            return;
        }
        for (Map.Entry<BlockPos, PatternData> entry : patternMap.entrySet()) {
            BlockPos pos2 = entry.getKey();
            PatternData patternData = entry.getValue();
            BlockPatternCapability capability = BlockPatternCapability.getBlockPatterns(pos2, level);
            capability.setPattern(pos2, patternData);
            level.getChunkAt(pos2).setUnsaved(true);
        }
        Set<BlockPos> blockPosList = patternMap.keySet();
        Set chunkPositions = blockPosList.stream().map(ChunkPos::new).collect(Collectors.toSet());
        List<LevelChunk> levelChunks = chunkPositions.stream().map(pos -> level.getChunk(pos.x, pos.z)).toList();
        for (LevelChunk levelChunk : levelChunks) {
            BlockPatternCapability.getBlockPatterns(levelChunk).sync(levelChunk.getPos().getWorldPosition(), level);
        }
    }

    public static PatternData getPattern(BlockPos pos, Level level) {
        LevelChunk chunk = level.getChunkAt(pos);
        return ((BlockPatternCapability)chunk.getData(ModDataAttachments.BLOCK_PATTERNS)).getPattern(pos);
    }

    public PatternData getPattern(BlockPos pos) {
        return this.patterns.get(pos);
    }

    public static boolean hasPattern(BlockPos pos, Level level) {
        BlockPatternCapability capability = BlockPatternCapability.getBlockPatterns(pos, level);
        return capability.hasPattern(pos);
    }

    public boolean hasPattern(BlockPos pos) {
        return this.patterns.containsKey(pos);
    }

    public static void removePattern(BlockPos pos, Level level) {
        BlockPatternCapability capability = BlockPatternCapability.getBlockPatterns(pos, level);
        capability.removePattern(pos);
        level.getChunkAt(pos).setUnsaved(true);
        if (!level.isClientSide) {
            capability.sync(pos, level);
        }
    }

    public void removePattern(BlockPos pos) {
        this.patterns.remove(pos);
    }

    public Stream<BlockPos> getPatternPositionsNear(BlockPos pos, int renderDistance) {
        return this.patterns.keySet().stream().filter(p -> p.closerThan((Vec3i)pos, (double)renderDistance));
    }

    public boolean isEmpty() {
        return this.patterns.isEmpty();
    }

    public void sync(BlockPos pos, Level level) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncBlockPatternsPacket(this, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void load(BlockPatternCapability capability) {
        this.patterns.clear();
        this.patterns.putAll(capability.patterns);
    }

    public int count() {
        return this.patterns.size();
    }

    public static void recolor(Level level, BlockPos pos, int color) {
        PatternData data = BlockPatternCapability.getPattern(pos, level);
        BlockPatternCapability.setPattern(pos, new PatternData(data.patternId, color, data.direction, data.isGlowing), level);
        level.getChunkAt(pos).setUnsaved(true);
    }

    public static void enableGlowing(Level level, BlockPos pos) {
        PatternData data = BlockPatternCapability.getPattern(pos, level);
        BlockPatternCapability.setPattern(pos, new PatternData(data.patternId, data.color, data.direction, true), level);
        level.getChunkAt(pos).setUnsaved(true);
    }

    public record PatternData(int patternId, int color, Direction direction, boolean isGlowing) {
        public static final Codec<PatternData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(PatternData::patternId), (App)Codec.INT.fieldOf("col").forGetter(PatternData::color), (App)Direction.CODEC.fieldOf("dir").forGetter(PatternData::direction), (App)Codec.BOOL.fieldOf("glw").forGetter(PatternData::isGlowing)).apply((Applicative)instance, PatternData::new));
        public static final StreamCodec<? super ByteBuf, PatternData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PatternData::patternId, (StreamCodec)ByteBufCodecs.INT, PatternData::color, (StreamCodec)Direction.STREAM_CODEC, PatternData::direction, (StreamCodec)ByteBufCodecs.BOOL, PatternData::isGlowing, PatternData::new);
    }
}

